package cn.takujo.takujoframework.mappingfinder;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import cn.takujo.takujoframework.common.util.ClassUtil;

public class MappingFinder {

	/**
	 * 返回映射结果
	 * 
	 * @param enterClass
	 *            扫描这个类所在的包及其子包
	 * @param requestMapping
	 *            requestMapping注解
	 * @return
	 */
	public static List<Mapping> enter(Class<?> enterClass, Class<? extends Annotation> requestMapping) {
		return scan(enterClass.getPackage(), requestMapping);
	}

	/**
	 * 返回映射结果，并写入到文件
	 * 
	 * @param enterClass
	 *            扫描这个类所在的包及其子包
	 * @param requestMapping
	 *            requestMapping注解
	 * @param outFile
	 *            例 d:/mapping.txt(全路径)
	 * @return
	 */
	public static List<Mapping> enter(Class<?> enterClass, Class<? extends Annotation> requestMapping, String outFile) {
		List<Mapping> scan = scan(enterClass.getPackage(), requestMapping);
		File file = new File(outFile);
		File parentFile = file.getParentFile();
		if (!parentFile.exists()) {
			parentFile.mkdirs();
		}
		try {
			file.createNewFile();
			if (file.exists()) {
				FileOutputStream fo = new FileOutputStream(file);
				BufferedOutputStream bfo = new BufferedOutputStream(fo);
				for (Mapping mapping : scan) {
					String mappingUrl = mapping.getMappingUrl();
					String mappingMethod = mapping.getMappingMethod();
					String requiredParam = mapping.getRequiredParam();
					String returnValue = mapping.getReturnValue();
					String description = mapping.getDescription();
					String belongController = mapping.getBelongController();
					String line = "| url: " + mappingUrl + " | method: " + mappingMethod + " | param: " + requiredParam
							+ " | return: " + returnValue + " | controller: " + belongController + " | description: "
							+ description + " | # ";
					byte[] bytes = line.getBytes();
					bfo.write(bytes);
				}
				bfo.flush();
				bfo.close();
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return scan;
	}

	/**
	 * 扫描注解，返回映射结果
	 * 
	 * @param pkg
	 *            被扫描包
	 * @param valueAnnotation
	 *            含有value方法的注解
	 * @return
	 */
	private static List<Mapping> scan(Package pkg, Class<? extends Annotation> valueAnnotation) {
		List<Mapping> mappings = new ArrayList<>();
		List<Class<?>> list = ClassUtil.getClassesByPackage(pkg);
		if (!list.isEmpty()) {
			for (Iterator<Class<?>> iterator = list.iterator(); iterator.hasNext();) {
				Class<?> c = (Class<?>) iterator.next();
				Method[] methods = c.getMethods();
				for (Method method : methods) {
					Findable annotation = method.getAnnotation(Findable.class);
					if (annotation != null) {
						Annotation rm = method.getAnnotation(valueAnnotation);
						if (rm != null) {
							try {
								Mapping mapping = new Mapping();
								mapping.setBelongController(c.getSimpleName());
								mapping.setMappingMethod(method.getName());
								mapping.setReturnValue(method.getReturnType().getSimpleName());
								Class<?>[] parameterTypes = method.getParameterTypes();
								StringBuffer stringBuffer = new StringBuffer();
								for (Class<?> pac : parameterTypes) {
									stringBuffer.append(pac.getSimpleName() + ",");
								}
								int lastIndexOf = stringBuffer.lastIndexOf(",");
								if (lastIndexOf != -1) {
									stringBuffer.delete(lastIndexOf, lastIndexOf + 1);
								}
								mapping.setRequiredParam(stringBuffer.toString());
								String description = annotation.value();
								mapping.setDescription(description);
								Method value = rm.getClass().getMethod("value");
								String[] ss = (String[]) value.invoke(rm);
								String url = ss[0];
								mapping.setMappingUrl(url);
								mappings.add(mapping);
							} catch (NoSuchMethodException e) {
								e.printStackTrace();
							} catch (SecurityException e) {
								e.printStackTrace();
							} catch (IllegalAccessException e) {
								e.printStackTrace();
							} catch (IllegalArgumentException e) {
								e.printStackTrace();
							} catch (InvocationTargetException e) {
								e.printStackTrace();
							}
						}
					}
				}
			}
		}
		return mappings;
	}

}
