package cn.takujo.takujoframework.mybatis.sqlhelper.base;

import java.util.Map;

/**
 * 所有Rule必须实现
 * 
 * @author wzx
 *
 */
public interface Rule {

	String generate();

	/**
	 * 提交sql到SqlHelper，最后返回给mapper
	 * 
	 * @return 完整sql
	 */
	String commit();

	/**
	 * 转换成map 传到mapper方法中（也可以自定义map，规则见SqlHelper）
	 * 如果使用了in和嵌套，请注意需手动向map中注入需要的值，规则key：映射java对象属性名，value：所对应的值
	 * 
	 * @return map
	 */
	Map<String, Object> toMap();

}
