/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.takujoframework.mybatis.sqlhelper.update;

import cn.takujo.takujoframework.mybatis.sqlhelper.base.Condition;
import cn.takujo.takujoframework.mybatis.sqlhelper.base.Form;
import cn.takujo.takujoframework.mybatis.sqlhelper.base.Rule;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class UpdateRule<T extends Form>
extends Condition
implements Rule {
    private String table;
    private T form;
    private Class<? extends Form> cla;

    public UpdateRule(String table, T form) {
        this.table = table;
        this.form = form;
        this.cla = form.getClass();
    }

    public String set() {
        return this.values(new String[0]);
    }

    public String values(String ... value) {
        int length = value.length;
        if (length == 0) {
            return this.lengthEqualZero();
        }
        if (length == 1) {
            String name = value[0];
            if (this.isId(name)) {
                return " ";
            }
            Object o = this.fieldValueIsExist(name);
            if (o != null) {
                return name + " ";
            }
            return " ";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            Object o;
            String s = value[i];
            if (this.isId(s) || (o = this.fieldValueIsExist(s)) == null) continue;
            sb.append(s + " , ");
        }
        int lastIndexOf = sb.lastIndexOf(",");
        if (lastIndexOf != -1) {
            sb.deleteCharAt(lastIndexOf);
        }
        return sb.toString();
    }

    public static String value(String column, String property) {
        return column + "=#{" + property + "}";
    }

    private String lengthEqualZero() {
        Field[] declaredFields;
        Class<?> cla = this.form.getClass();
        ArrayList<String> p = new ArrayList<String>();
        for (Field field : declaredFields = cla.getDeclaredFields()) {
            Object o;
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (this.isSerializableField(modifiers) || name.equals("id") || (o = this.fieldGetMethodInvoke(name)) == null) continue;
            String value = "=#{" + name + "}";
            char[] array = name.toCharArray();
            StringBuffer sb = new StringBuffer();
            for (char c : array) {
                if (Character.isUpperCase(c)) {
                    sb.append('_');
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append(c);
            }
            p.add(sb.toString() + value);
        }
        int size = p.size();
        if (size != 0) {
            String[] ss = new String[size];
            p.toArray(ss);
            return this.values(ss);
        }
        return " ";
    }

    public String base() {
        return "UPDATE " + this.table + " SET ";
    }

    @Override
    public String generate() {
        return this.and(UpdateRule.equal("id", "id"));
    }

    @Override
    public String commit() {
        String generate = this.generate();
        if (!generate.trim().isEmpty()) {
            generate = "WHERE " + generate;
        }
        return this.base() + this.set() + generate;
    }

    public String and(String ... con) {
        int length = con.length;
        if (length == 0) {
            return " ";
        }
        if (length == 1) {
            String name = con[0];
            if (this.isDefine(name)) {
                return name.substring(1) + " ";
            }
            Object o = this.fieldValueIsExist(name);
            if (o != null) {
                return name + " ";
            }
            return " ";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String s = con[i];
            if (this.isDefine(s)) {
                String subs = s.substring(1);
                if (subs.trim().isEmpty()) continue;
                sb.append(subs + " AND ");
                continue;
            }
            Object o = this.fieldValueIsExist(s);
            if (o == null) continue;
            sb.append(s + " AND ");
        }
        int lastIndexOf = sb.lastIndexOf("AND");
        if (lastIndexOf != -1) {
            sb.delete(lastIndexOf, lastIndexOf + 3);
        }
        return sb.toString();
    }

    public String or(String ... con) {
        int length = con.length;
        if (length == 0) {
            return " ";
        }
        if (length == 1) {
            String name = con[0];
            if (this.isDefine(name)) {
                return name.substring(1) + " ";
            }
            Object o = this.fieldValueIsExist(name);
            if (o != null) {
                return name + " ";
            }
            return " ";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String s = con[i];
            if (this.isDefine(s)) {
                String subs = s.substring(1);
                if (subs.trim().isEmpty()) continue;
                sb.append(subs + " OR ");
                continue;
            }
            Object o = this.fieldValueIsExist(s);
            if (o == null) continue;
            sb.append(s + " OR ");
        }
        int lastIndexOf = sb.lastIndexOf("OR");
        if (lastIndexOf != -1) {
            sb.delete(lastIndexOf, lastIndexOf + 3);
        }
        return sb.toString();
    }

    public String andor(String ... con) {
        int length = con.length;
        if (length == 0) {
            return " ";
        }
        if (length == 1) {
            String name = con[0];
            String trim = name.trim();
            if (trim.equals("AND") || trim.equals("OR")) {
                return " ";
            }
            return name + " ";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String s = con[i];
            if (i != length - 1) {
                sb.append(s);
                continue;
            }
            String trim = s.trim();
            if (trim.equals("AND") || trim.equals("OR")) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> toMap() {
        Field[] declaredFields;
        Class<?> cla = this.form.getClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("myRule", this);
        for (Field field : declaredFields = cla.getDeclaredFields()) {
            Object o;
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (this.isSerializableField(modifiers) || (o = this.fieldGetMethodInvoke(name)) == null) continue;
            map.put(name, o);
        }
        return map;
    }

    private boolean isSerializableField(int modifiers) {
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    private Object fieldGetMethodInvoke(String field) {
        try {
            Method method = this.cla.getMethod("get" + field.substring(0, 1).toUpperCase() + field.substring(1), new Class[0]);
            return method.invoke(this.form, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object fieldValueIsExist(String field) {
        try {
            int indexOf = field.indexOf("{");
            int lastIndexOf = field.lastIndexOf("}");
            return this.fieldGetMethodInvoke(field.substring(indexOf + 1, lastIndexOf));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isId(String value) {
        int indexOf = value.indexOf("=");
        int lastIndexOf = value.lastIndexOf("}");
        String column = value.substring(0, indexOf);
        String property = value.substring(indexOf + 3, lastIndexOf);
        return column.equals("id") || property.equals("id");
    }

    public String getTable() {
        return this.table;
    }
}

