/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.takujoframework.mybatis.sqlhelper.find;

import cn.takujo.takujoframework.mybatis.sqlhelper.base.Condition;
import cn.takujo.takujoframework.mybatis.sqlhelper.base.Form;
import cn.takujo.takujoframework.mybatis.sqlhelper.base.Rule;
import cn.takujo.takujoframework.mybatis.sqlhelper.find.FindField;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FindRule<T extends Form>
extends Condition
implements Rule {
    public static final String DESC = " DESC ";
    public static final String ASC = " ASC ";
    private String table;
    private String sort;
    private String sortBy;
    private T form;
    private Class<? extends Form> cla;
    private List<FindField> fields;

    public FindRule(String table, T form) {
        this.table = table;
        this.form = form;
        this.cla = form.getClass();
    }

    public FindRule(String table, String sort, String sortBy, T form) {
        this.table = table;
        this.sort = sort;
        this.sortBy = sortBy;
        this.form = form;
        this.cla = form.getClass();
    }

    @Override
    public String generate() {
        return " ";
    }

    public String base(List<FindField> fields) {
        this.fields = fields;
        String filed = null;
        if (fields == null) {
            filed = "* ";
        } else {
            int length = fields.size();
            if (length == 0) {
                filed = "* ";
            } else if (length == 1) {
                filed = fields.get(0).result() + " ";
            } else {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < length; ++i) {
                    String s = fields.get(i).result();
                    if (i != length - 1) {
                        sb.append(s + " , ");
                        continue;
                    }
                    sb.append(s + " ");
                }
                filed = sb.toString();
            }
        }
        return "SELECT " + filed + "FROM " + this.table + " ";
    }

    @Override
    public String commit() {
        String base = this.base(this.fields);
        String generate = this.generate();
        if (!generate.trim().isEmpty()) {
            generate = "WHERE " + generate;
        }
        if (this.sort != null && !this.sort.trim().isEmpty()) {
            return base + generate + "ORDER BY " + this.sort + this.sortBy;
        }
        return base + generate;
    }

    public String and(String ... con) {
        int length = con.length;
        if (length == 0) {
            return " ";
        }
        if (length == 1) {
            String name = con[0];
            if (this.isDefine(name)) {
                return name.substring(1) + " ";
            }
            Object o = this.fieldValueIsExist(name);
            if (o != null) {
                return name + " ";
            }
            return " ";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String s = con[i];
            if (this.isDefine(s)) {
                String subs = s.substring(1);
                if (subs.trim().isEmpty()) continue;
                sb.append(subs + " AND ");
                continue;
            }
            Object o = this.fieldValueIsExist(s);
            if (o == null) continue;
            sb.append(s + " AND ");
        }
        int lastIndexOf = sb.lastIndexOf("AND");
        if (lastIndexOf != -1) {
            sb.delete(lastIndexOf, lastIndexOf + 3);
        }
        return sb.toString();
    }

    public String or(String ... con) {
        int length = con.length;
        if (length == 0) {
            return " ";
        }
        if (length == 1) {
            String name = con[0];
            if (this.isDefine(name)) {
                return name.substring(1) + " ";
            }
            Object o = this.fieldValueIsExist(name);
            if (o != null) {
                return name + " ";
            }
            return " ";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String s = con[i];
            if (this.isDefine(s)) {
                String subs = s.substring(1);
                if (subs.trim().isEmpty()) continue;
                sb.append(subs + " OR ");
                continue;
            }
            Object o = this.fieldValueIsExist(s);
            if (o == null) continue;
            sb.append(s + " OR ");
        }
        int lastIndexOf = sb.lastIndexOf("OR");
        if (lastIndexOf != -1) {
            sb.delete(lastIndexOf, lastIndexOf + 3);
        }
        return sb.toString();
    }

    public String andor(String ... con) {
        int length = con.length;
        if (length == 0) {
            return " ";
        }
        if (length == 1) {
            String name = con[0];
            String trim = name.trim();
            if (trim.equals("AND") || trim.equals("OR")) {
                return " ";
            }
            return name + " ";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String s = con[i];
            if (i != length - 1) {
                sb.append(s);
                continue;
            }
            String trim = s.trim();
            if (trim.equals("AND") || trim.equals("OR")) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> toMap() {
        Field[] declaredFields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("myRule", this);
        for (Field field : declaredFields = this.cla.getDeclaredFields()) {
            Object o;
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (this.isSerializableField(modifiers) || (o = this.fieldGetMethodInvoke(name)) == null) continue;
            map.put(name, o);
        }
        return map;
    }

    private boolean isSerializableField(int modifiers) {
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    private Object fieldGetMethodInvoke(String field) {
        try {
            Method method = this.cla.getMethod("get" + field.substring(0, 1).toUpperCase() + field.substring(1), new Class[0]);
            return method.invoke(this.form, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object fieldValueIsExist(String field) {
        try {
            int indexOf = field.indexOf("{");
            int lastIndexOf = field.lastIndexOf("}");
            return this.fieldGetMethodInvoke(field.substring(indexOf + 1, lastIndexOf));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTable() {
        return this.table;
    }

    public String getSort() {
        return this.sort;
    }

    public String getSortBy() {
        return this.sortBy;
    }
}

