package cn.takujo.takujoframework.mybatis.sqlhelper.delete;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import cn.takujo.takujoframework.mybatis.sqlhelper.base.Condition;
import cn.takujo.takujoframework.mybatis.sqlhelper.base.Form;
import cn.takujo.takujoframework.mybatis.sqlhelper.base.Rule;
import lombok.Getter;

/**
 * 删除规则，需要继承或匿名实现
 * 
 * @author wzx
 *
 * @param <T>
 *            Form的实现类
 */
public abstract class DeleteRule<T extends Form> extends Condition implements Rule {

	@Getter
	private String table;

	private T form;

	private Class<? extends Form> cla;

	/**
	 * @param table
	 *            表名
	 * @param form
	 *            Form实现类
	 */
	public DeleteRule(String table, T form) {
		this.table = table;
		this.form = form;
		this.cla = form.getClass();
	}

	/**
	 * @return 基础sql
	 */
	public String base() {
		return "DELETE FROM " + table + " WHERE ";
	}

	/**
	 * 重要！ 用来生成删除条件,重写时return的最外层一定是and()或or() 默认是按id作为删除条件
	 * 
	 * @return 条件sql
	 */
	@Override
	public String generate() {
		return and(equal("id", "id"));
	}

	@Override
	public String commit() {
		return base() + generate();
	}

	/**
	 * and
	 * 
	 * @param con
	 *            条件必须是以下方法的返回值，且任意数量个（可以为零）：
	 *            like、greaterThan、greaterOrEqual、equal、lessThan、lessOrEqual、nesting...
	 * @return 多条件
	 */
	public String and(String... con) {
		int length = con.length;
		if (length == 0) {
			return " ";
		} else if (length == 1) {
			String name = con[0];
			if (isDefine(name)) {
				return name.substring(1) + " ";
			} else {
				Object o = fieldValueIsExist(name);
				if (o != null) {
					return name + " ";
				} else {
					return " ";
				}
			}
		} else {
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < length; i++) {
				String s = con[i];
				if (isDefine(s)) {
					String subs = s.substring(1);
					if (!subs.trim().isEmpty()) {
						sb.append(subs + " AND ");
					}
				} else {
					Object o = fieldValueIsExist(s);
					if (o != null) {
						sb.append(s + " AND ");
					}
				}
			}
			int lastIndexOf = sb.lastIndexOf("AND");
			if (lastIndexOf != -1) {
				sb.delete(lastIndexOf, lastIndexOf + 3);
			}
			return sb.toString();
		}
	}

	/**
	 * or
	 * 
	 * @param con
	 *            条件必须是以下方法的返回值，且任意数量个（可以为零）：
	 *            like、greaterThan、greaterOrEqual、equal、lessThan、lessOrEqual、nesting...
	 * @return 多条件
	 */
	public String or(String... con) {
		int length = con.length;
		if (length == 0) {
			return " ";
		} else if (length == 1) {
			String name = con[0];
			if (isDefine(name)) {
				return name.substring(1) + " ";
			} else {
				Object o = fieldValueIsExist(name);
				if (o != null) {
					return name + " ";
				} else {
					return " ";
				}
			}
		} else {
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < length; i++) {
				String s = con[i];
				if (isDefine(s)) {
					String subs = s.substring(1);
					if (!subs.trim().isEmpty()) {
						sb.append(subs + " OR ");
					}
				} else {
					Object o = fieldValueIsExist(s);
					if (o != null) {
						sb.append(s + " OR ");
					}
				}
			}
			int lastIndexOf = sb.lastIndexOf("OR");
			if (lastIndexOf != -1) {
				sb.delete(lastIndexOf, lastIndexOf + 3);
			}
			return sb.toString();
		}
	}

	/**
	 * and和or混用
	 * 
	 * @param con
	 *            条件必须是以下方法的返回值，且任意数量个（可以为零）：
	 *            and、or（必须用attachAndSign或attachOrSign方法连接and或or）
	 * @return 多条件
	 */
	public String andor(String... con) {
		int length = con.length;
		if (length == 0) {
			return " ";
		} else if (length == 1) {
			String name = con[0];
			String trim = name.trim();
			if (trim.equals("AND") || trim.equals("OR")) {
				return " ";
			} else {
				return name + " ";
			}
		} else {
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < length; i++) {
				String s = con[i];
				if (i != length - 1) {
					sb.append(s);
				} else {
					String trim = s.trim();
					if (trim.equals("AND") || trim.equals("OR")) {
						continue;
					} else {
						sb.append(s);
					}
				}
			}
			return sb.toString();
		}
	}

	@Override
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<>();
		map.put("myRule", this);
		Field[] declaredFields = cla.getDeclaredFields();
		for (Field field : declaredFields) {
			String name = field.getName();
			int modifiers = field.getModifiers();
			if (!isSerializableField(modifiers)) {
				Object o = fieldGetMethodInvoke(name);
				if (o != null) {
					map.put(name, o);
				}
			}
		}
		return map;
	}

	/**
	 * 判断是否为序列化字段
	 * 
	 * @param modifiers
	 * @return true：是 false：否
	 */
	private boolean isSerializableField(int modifiers) {
		if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 调用某个字段的get方法
	 * 
	 * @param field
	 *            字段名
	 * @return 调用结果为空则返回null
	 */
	private Object fieldGetMethodInvoke(String field) {
		try {
			Method method = cla.getMethod("get" + field.substring(0, 1).toUpperCase() + field.substring(1));
			return method.invoke(form);
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * form中字段值是否存在
	 * 
	 * @return 如果有则返回值，没有则返回null
	 */
	private Object fieldValueIsExist(String field) {
		try {
			int indexOf = field.indexOf("{");
			int lastIndexOf = field.lastIndexOf("}");
			return fieldGetMethodInvoke(field.substring(indexOf + 1, lastIndexOf));
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

}
