/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.common_api.util;

import cn.takujo.common_api.exception.HttpException;
import cn.takujo.common_api.exception.JsonException;
import cn.takujo.common_api.util.HttpUtil;
import cn.takujo.common_api.util.JsonUtil;
import java.util.Map;
import lombok.NonNull;

public final class TencentLocationUtil {
    @NonNull
    private String key;
    private static final String URL = "https://apis.map.qq.com/ws/geocoder/v1/";

    public String recommendAddress(String lat, String lng) {
        String location = lat + "," + lng;
        try {
            String str = HttpUtil.get("https://apis.map.qq.com/ws/geocoder/v1/?location=" + location + "&key=" + this.key);
            Map<String, Object> map = JsonUtil.toMap(str);
            Map result = (Map)map.get("result");
            Map formatted_addresses = (Map)result.get("formatted_addresses");
            String address = (String)result.get("address");
            String recommend = (String)formatted_addresses.get("recommend");
            return address + recommend;
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (JsonException e) {
            e.printStackTrace();
        }
        return "";
    }

    public TencentLocationUtil(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        this.key = key;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    public void setKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        this.key = key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentLocationUtil)) {
            return false;
        }
        TencentLocationUtil other = (TencentLocationUtil)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "TencentLocationUtil(key=" + this.getKey() + ")";
    }
}

