package cn.takujo.common_api.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import cn.takujo.common_api.exception.PicException;
import net.coobird.thumbnailator.Thumbnails;

/**
 * 压缩图片
 * 
 * @author wzx
 *
 */
public final class PicUtil {

	/**
	 * 压缩图片
	 * 
	 * @param picFile
	 *            图片文件（完整路径）
	 * @param outFile
	 *            输出路径（完整）
	 * @param scale
	 *            缩放比例0-1
	 * @param quality
	 *            输出质量0-1
	 * @throws PicException
	 *             图片压缩异常
	 */
	public static void compress(File picFile, String outFile, double scale, double quality) throws PicException {
		try {
			mkdirs(outFile);
			Thumbnails.of(picFile).scale(scale).outputQuality(quality).toFile(outFile);
		} catch (IOException e) {
			throw new PicException("pic01", "图片压缩失败");
		}
	}

	/**
	 * 压缩图片
	 * 
	 * @param picFile
	 *            图片文件（完整路径）
	 * @param outFile
	 *            输出路径（完整）
	 * @param width
	 *            输出宽度
	 * @param height
	 *            输出高度
	 * @param quality
	 *            输出质量0-1
	 * @throws PicException
	 *             图片压缩异常
	 */
	public static void compress(File picFile, String outFile, int width, int height, double quality)
			throws PicException {
		try {
			mkdirs(outFile);
			Thumbnails.of(picFile).size(width, height).outputQuality(quality).toFile(outFile);
		} catch (IOException e) {
			throw new PicException("pic02", "图片压缩失败");
		}
	}

	/**
	 * 压缩图片
	 * 
	 * @param input
	 *            文件输入流
	 * @param outFile
	 *            输出路径（完整）
	 * @param width
	 *            输出宽度
	 * @param height
	 *            输出高度
	 * @param quality
	 *            输出质量0-1
	 * @throws PicException
	 *             图片压缩异常
	 */
	public static void compress(InputStream input, String outFile, int width, int height, double quality)
			throws PicException {
		try {
			mkdirs(outFile);
			Thumbnails.of(input).size(width, height).outputQuality(quality).toFile(outFile);
		} catch (IOException e) {
			throw new PicException("pic03", "图片压缩失败");
		}
	}

	/**
	 * 
	 * @param input
	 *            文件输入流
	 * @param outFile
	 *            输出路径（完整）
	 * @param scale
	 *            缩放比例0-1
	 * @param quality
	 *            输出质量0-1
	 * @throws PicException
	 *             图片压缩异常
	 */
	public static void compress(InputStream input, String outFile, double scale, double quality) throws PicException {
		try {
			mkdirs(outFile);
			Thumbnails.of(input).scale(scale).outputQuality(quality).toFile(outFile);
		} catch (IOException e) {
			throw new PicException("pic04", "图片压缩失败");
		}
	}

	private static void mkdirs(String outFile) {
		File parent = new File(outFile).getParentFile();
		if (!parent.exists()) {
			parent.mkdirs();
		}
	}

}
