package cn.takujo.common_api.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import lombok.Data;

/**
 * 数据源yml文件生成，文件名为application.yml (默认使用druid数据源)
 * 
 * @author wzx
 *
 */
@Data
public final class DataSourceYmlBuilder {

	private String url;
	private String username;
	private String password;
	private String type = "com.alibaba.druid.pool.DruidDataSource";

	private String tab = " \n";
	private String t = "    ";

	public DataSourceYmlBuilder(String url, String username, String password, String type) {
		this.url = url;
		this.username = username;
		this.password = password;
		this.type = type;
	}

	public DataSourceYmlBuilder(String url, String username, String password) {
		this.url = url;
		this.username = username;
		this.password = password;
	}

	/**
	 * 构建生成
	 * 
	 * @param path
	 *            保存路径，例：c:/data
	 * @return true即是生成成功，false为失败
	 */
	public boolean build(String path) {
		try (FileOutputStream fo = new FileOutputStream(path + File.separator + "application.yml")) {
			fo.write(head());
			fo.write(middle());
			fo.write(end());
			return true;
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return false;
	}

	private byte[] end() {
		String m = t + "filters: stat,wall" + tab + t
				+ "connectionProperties: druid.stat.mergeSql=true,druid.stat.slowSqlMillis=5000" + tab + t
				+ "useGlobalDataSourceStat: true" + tab;
		return m.getBytes();
	}

	private byte[] head() {
		String h = "spring: " + tab + "  datasource: " + tab + t + "url: " + url + tab + t + "username: " + username
				+ tab + t + "password: " + password + tab + t + "type: " + type + tab;
		return h.getBytes();
	}

	private byte[] middle() {
		String m = t + "initialSize: 5" + tab + t + "maxActive: 20" + tab + t + "maxWait: 60000" + tab + t
				+ "minIdle: 5" + tab + t + "timeBetweenEvictionRunsMillis: 60000" + tab + t
				+ "minEvictableIdleTimeMillis: 300000" + tab + t + "validationQuery: SELECT 'x'" + tab + t
				+ "testWhileIdle: true" + tab + t + "testOnBorrow: false" + tab + t + "testOnReturn: false" + tab;
		return m.getBytes();
	}

}
