package cn.takujo.common_api.log;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 可被日志化
 * 
 * @author wzx
 *
 */
@Documented
@Retention(RUNTIME)
@Target(METHOD)
public @interface Logable {

	/**
	 * 业务描述
	 * 
	 * @return 业务方法动作
	 */
	String action() default "";

	/**
	 * 业务类型
	 * 
	 * @return 类型
	 */
	String type() default "";

}
