package cn.takujo.common_api.util;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.ConsoleAppender;

public class LoggerBuilder {

	private static final Map<String, Logger> CONTAINER = new HashMap<>();

	private static final Level LEVEL = Level.INFO;

	public static Logger getLogger(String name) {
		Logger logger = CONTAINER.get(name);
		if (logger != null) {
			return logger;
		}
		synchronized (LoggerBuilder.class) {
			logger = CONTAINER.get(name);
			if (logger != null) {
				return logger;
			}
			logger = build(name);
			CONTAINER.put(name, logger);
		}
		return logger;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	private static Logger build(String name) {
		LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
		Logger logger = context.getLogger(name);
		logger.setAdditive(false);
		PatternLayoutEncoder encoder = new PatternLayoutEncoder();
		encoder.setContext(context);
		encoder.setPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] %-5level %logger{50} - %msg%n");
		encoder.start();
		ConsoleAppender console = new ConsoleAppender();
		console.setContext(context);
		console.setEncoder(encoder);
		console.start();
		logger.addAppender(console);
		logger.setLevel(LEVEL);
		return logger;
	}

}
