package cn.takujo.common_api.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

import org.springframework.web.multipart.MultipartFile;

import lombok.extern.slf4j.Slf4j;

/**
 * File工具
 * 
 * @author wzx
 *
 */
@Slf4j
public final class FileUtil {

	public static void saveFile(MultipartFile file, File save) {
		BufferedOutputStream stream = null;
		if (!file.isEmpty()) {
			try {
				byte[] bytes = file.getBytes();
				log.info("save file: " + save.getAbsolutePath());
				stream = new BufferedOutputStream(new FileOutputStream(save));
				stream.write(bytes);
				stream.close();
			} catch (Exception e) {
				stream = null;
			}
			log.info("upload: success");
		} else {
			log.warn("upload: failure");
		}
	}

	public static void deleteFiles(File file) {
		if (file.exists()) {
			if (file.isDirectory()) {
				File[] fs = file.listFiles();
				for (File f : fs) {
					deleteFiles(f);
				}
				boolean result = file.delete();
				log.info("delete directory: " + file.getName() + " " + result);
			} else if (file.isFile()) {
				boolean result = file.delete();
				log.info("delete file: " + file.getAbsolutePath() + " " + result);
			}
		}
	}

}
