/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.xml;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.oxm.Marshaller;
import infra.validation.BindingResult;
import infra.web.RequestContext;
import infra.web.view.AbstractView;
import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class MarshallingView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/xml";
    @Nullable
    private Marshaller marshaller;
    @Nullable
    private String modelKey;

    public MarshallingView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setExposePathVariables(false);
    }

    public MarshallingView(Marshaller marshaller) {
        this();
        Assert.notNull((Object)marshaller, (String)"Marshaller is required");
        this.marshaller = marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setModelKey(String modelKey) {
        this.modelKey = modelKey;
    }

    protected void initApplicationContext() {
        Assert.state((this.marshaller != null ? 1 : 0) != 0, (String)"Property 'marshaller' is required");
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, RequestContext request) throws Exception {
        Object toBeMarshalled = this.locateToBeMarshalled(model);
        if (toBeMarshalled == null) {
            throw new IllegalStateException("Unable to locate object to be marshalled in model: " + model);
        }
        Assert.state((this.marshaller != null ? 1 : 0) != 0, (String)"No Marshaller set");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        this.marshaller.marshal(toBeMarshalled, (Result)new StreamResult(baos));
        this.setResponseContentType(request);
        request.setContentLength(baos.size());
        baos.writeTo(request.getOutputStream());
    }

    @Nullable
    protected Object locateToBeMarshalled(Map<String, Object> model) throws IllegalStateException {
        if (this.modelKey != null) {
            Object value = model.get(this.modelKey);
            if (value == null) {
                throw new IllegalStateException("Model contains no object with key [" + this.modelKey + "]");
            }
            if (!this.isEligibleForMarshalling(this.modelKey, value)) {
                throw new IllegalStateException("Model object [" + value + "] retrieved via key [" + this.modelKey + "] is not supported by the Marshaller");
            }
            return value;
        }
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            Object value = entry.getValue();
            if (value == null || model.size() != 1 && value instanceof BindingResult || !this.isEligibleForMarshalling(entry.getKey(), value)) continue;
            return value;
        }
        return null;
    }

    protected boolean isEligibleForMarshalling(String modelKey, Object value) {
        Assert.state((this.marshaller != null ? 1 : 0) != 0, (String)"No Marshaller set");
        Class classToCheck = value.getClass();
        if (value instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)value;
            classToCheck = jaxbElement.getDeclaredType();
        }
        return this.marshaller.supports(classToCheck);
    }
}

