/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.xml;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import infra.http.converter.json.Jackson2ObjectMapperBuilder;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.view.json.AbstractJackson2View;
import java.util.Map;

public class MappingJackson2XmlView
extends AbstractJackson2View {
    public static final String DEFAULT_CONTENT_TYPE = "application/xml";
    @Nullable
    private String modelKey;

    public MappingJackson2XmlView() {
        super((ObjectMapper)Jackson2ObjectMapperBuilder.xml().build(), DEFAULT_CONTENT_TYPE);
    }

    public MappingJackson2XmlView(XmlMapper xmlMapper) {
        super((ObjectMapper)xmlMapper, DEFAULT_CONTENT_TYPE);
    }

    @Override
    public void setModelKey(String modelKey) {
        this.modelKey = modelKey;
    }

    @Override
    protected Object filterModel(Map<String, Object> model) {
        Object value = null;
        if (this.modelKey != null) {
            value = model.get(this.modelKey);
            if (value == null) {
                throw new IllegalStateException("Model contains no object with key [" + this.modelKey + "]");
            }
        } else {
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                if (entry.getKey().equals(JsonView.class.getName())) continue;
                if (value != null) {
                    throw new IllegalStateException("Model contains more than one object to render, only one is supported");
                }
                value = entry.getValue();
            }
        }
        Assert.state((value != null ? 1 : 0) != 0, (String)"Model contains no object to render");
        return value;
    }
}

