/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.json;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import infra.http.converter.json.Jackson2ObjectMapperBuilder;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.validation.BindingResult;
import infra.web.view.json.AbstractJackson2View;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MappingJackson2JsonView
extends AbstractJackson2View {
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    @Nullable
    private String jsonPrefix;
    @Nullable
    private Set<String> modelKeys;
    private boolean extractValueFromSingleKeyModel = false;

    public MappingJackson2JsonView() {
        super((ObjectMapper)Jackson2ObjectMapperBuilder.json().build(), DEFAULT_CONTENT_TYPE);
    }

    public MappingJackson2JsonView(ObjectMapper objectMapper) {
        super(objectMapper, DEFAULT_CONTENT_TYPE);
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    @Override
    public void setModelKey(String modelKey) {
        this.modelKeys = Collections.singleton(modelKey);
    }

    public void setModelKeys(@Nullable Set<String> modelKeys) {
        this.modelKeys = modelKeys;
    }

    @Nullable
    public final Set<String> getModelKeys() {
        return this.modelKeys;
    }

    public void setExtractValueFromSingleKeyModel(boolean extractValueFromSingleKeyModel) {
        this.extractValueFromSingleKeyModel = extractValueFromSingleKeyModel;
    }

    @Override
    protected Object filterModel(Map<String, Object> model) {
        HashMap result = CollectionUtils.newHashMap((int)model.size());
        Set<String> modelKeys = CollectionUtils.isNotEmpty(this.modelKeys) ? this.modelKeys : model.keySet();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            String clazz = entry.getKey();
            if (entry.getValue() instanceof BindingResult || !modelKeys.contains(clazz) || clazz.equals(JsonView.class.getName()) || clazz.equals(FilterProvider.class.getName())) continue;
            result.put(clazz, entry.getValue());
        }
        return this.extractValueFromSingleKeyModel && result.size() == 1 ? result.values().iterator().next() : result;
    }

    @Override
    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
    }
}

