/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.json;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import infra.http.converter.json.MappingJacksonValue;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.view.AbstractView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractJackson2View
extends AbstractView {
    private ObjectMapper objectMapper;
    private JsonEncoding encoding = JsonEncoding.UTF8;
    @Nullable
    private Boolean prettyPrint;
    private boolean disableCaching = true;
    protected boolean updateContentLength = false;

    protected AbstractJackson2View(ObjectMapper objectMapper, String contentType) {
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
        this.setContentType(contentType);
        this.setExposePathVariables(false);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setEncoding(JsonEncoding encoding) {
        Assert.notNull((Object)encoding, (String)"'encoding' is required");
        this.encoding = encoding;
    }

    public final JsonEncoding getEncoding() {
        return this.encoding;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint.booleanValue());
        }
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public void setUpdateContentLength(boolean updateContentLength) {
        this.updateContentLength = updateContentLength;
    }

    @Override
    protected void prepareResponse(RequestContext context) {
        this.setResponseContentType(context);
        if (this.disableCaching) {
            context.responseHeaders().setCacheControl("no-store");
        }
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, RequestContext request) throws Exception {
        OutputStream stream;
        ByteArrayOutputStream temporaryStream = null;
        if (this.updateContentLength) {
            temporaryStream = this.createTemporaryOutputStream();
            stream = temporaryStream;
        } else {
            stream = request.getOutputStream();
        }
        Object value = this.filterAndWrapModel(model, request);
        this.writeContent(stream, value);
        if (temporaryStream != null) {
            this.writeToResponse(request, temporaryStream);
        }
    }

    protected Object filterAndWrapModel(Map<String, Object> model, RequestContext request) {
        Object value = this.filterModel(model);
        Class serializationView = (Class)model.get(JsonView.class.getName());
        FilterProvider filters = (FilterProvider)model.get(FilterProvider.class.getName());
        if (serializationView != null || filters != null) {
            MappingJacksonValue container = new MappingJacksonValue(value);
            if (serializationView != null) {
                container.setSerializationView(serializationView);
            }
            if (filters != null) {
                container.setFilters(filters);
            }
            value = container;
        }
        return value;
    }

    protected void writeContent(OutputStream stream, Object object) throws IOException {
        try (JsonGenerator generator = this.objectMapper.getFactory().createGenerator(stream, this.encoding);){
            ObjectWriter objectWriter;
            this.writePrefix(generator, object);
            Object value = object;
            Class<?> serializationView = null;
            FilterProvider filters = null;
            if (value instanceof MappingJacksonValue) {
                MappingJacksonValue container = (MappingJacksonValue)value;
                value = container.getValue();
                serializationView = container.getSerializationView();
                filters = container.getFilters();
            }
            ObjectWriter objectWriter2 = objectWriter = serializationView != null ? this.objectMapper.writerWithView(serializationView) : this.objectMapper.writer();
            if (filters != null) {
                objectWriter = objectWriter.with(filters);
            }
            objectWriter.writeValue(generator, value);
            this.writeSuffix(generator, object);
            generator.flush();
        }
    }

    public abstract void setModelKey(String var1);

    protected abstract Object filterModel(Map<String, Object> var1);

    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
    }

    protected void writeSuffix(JsonGenerator generator, Object object) throws IOException {
    }
}

