/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.groovy;

import groovy.text.Template;
import groovy.text.markup.MarkupTemplateEngine;
import infra.beans.BeansException;
import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.NoSuchBeanDefinitionException;
import infra.context.ApplicationContext;
import infra.context.ApplicationContextException;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.view.AbstractTemplateView;
import infra.web.view.ViewRenderingException;
import infra.web.view.groovy.GroovyMarkupConfig;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class GroovyMarkupView
extends AbstractTemplateView {
    @Nullable
    private MarkupTemplateEngine engine;

    public void setTemplateEngine(MarkupTemplateEngine engine) {
        this.engine = engine;
    }

    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext();
        if (this.engine == null) {
            this.setTemplateEngine(this.autodetectMarkupTemplateEngine());
        }
    }

    protected MarkupTemplateEngine autodetectMarkupTemplateEngine() throws BeansException {
        try {
            return ((GroovyMarkupConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((BeanFactory)this.obtainApplicationContext(), GroovyMarkupConfig.class, (boolean)true, (boolean)false)).getTemplateEngine();
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Expected a single GroovyMarkupConfig bean in the current Web application context or the parent root context: GroovyMarkupConfigurer is the usual implementation. This bean may have any name.", (Throwable)ex);
        }
    }

    @Override
    public boolean checkResource(Locale locale) throws Exception {
        Assert.state((this.engine != null ? 1 : 0) != 0, (String)"No MarkupTemplateEngine set");
        try {
            this.engine.resolveTemplate(this.getUrl());
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    @Override
    protected void renderMergedTemplateModel(Map<String, Object> model, RequestContext context) throws Exception {
        String url = this.getUrl();
        Assert.state((url != null ? 1 : 0) != 0, (String)"'url' not set");
        Template template = this.getTemplate(url);
        template.make(model).writeTo((Writer)new BufferedWriter(context.getWriter()));
    }

    protected Template getTemplate(String viewUrl) throws Exception {
        Assert.state((this.engine != null ? 1 : 0) != 0, (String)"No MarkupTemplateEngine set");
        try {
            return this.engine.createTemplateByPath(viewUrl);
        }
        catch (ClassNotFoundException ex) {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            throw new ViewRenderingException("Could not find class while rendering Groovy Markup view with name '%s': %s'".formatted(this.getUrl(), ex.getMessage()), cause);
        }
    }
}

