/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.freemarker;

import freemarker.template.Configuration;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.view.AbstractTemplateViewResolver;
import infra.web.view.AbstractUrlBasedView;
import infra.web.view.View;
import infra.web.view.freemarker.FreeMarkerView;
import java.util.Locale;

public class FreeMarkerViewResolver
extends AbstractTemplateViewResolver {
    public FreeMarkerViewResolver() {
        this.setViewClass(this.requiredViewClass());
    }

    public FreeMarkerViewResolver(String prefix, String suffix) {
        this();
        this.setPrefix(prefix);
        this.setSuffix(suffix);
    }

    @Override
    protected Class<?> requiredViewClass() {
        return FreeMarkerView.class;
    }

    @Override
    protected AbstractUrlBasedView instantiateView() {
        return this.getViewClass() == FreeMarkerView.class ? new FreeMarkerView() : super.instantiateView();
    }

    @Override
    @Nullable
    protected View loadView(String viewName, Locale locale) throws Exception {
        View view = super.loadView(viewName, locale);
        if (view instanceof FreeMarkerView) {
            FreeMarkerView freeMarkerView = (FreeMarkerView)view;
            this.postProcessView(freeMarkerView);
        }
        return view;
    }

    protected void postProcessView(FreeMarkerView freeMarkerView) {
        Configuration configuration;
        if (this.getContentType() != null) {
            return;
        }
        String encoding = freeMarkerView.getEncoding();
        if (encoding == null && (configuration = freeMarkerView.obtainConfiguration()).isDefaultEncodingExplicitlySet()) {
            encoding = configuration.getDefaultEncoding();
        }
        if (StringUtils.hasText((String)encoding)) {
            String contentType = "text/html;charset=" + encoding;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting Content-Type for view [%s] to: %s".formatted(freeMarkerView, contentType));
            }
            freeMarkerView.setContentType(contentType);
        }
    }
}

