/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.freemarker;

import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import infra.beans.BeansException;
import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.NoSuchBeanDefinitionException;
import infra.context.ApplicationContextException;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.view.AbstractTemplateView;
import infra.web.view.freemarker.FreeMarkerConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;

public class FreeMarkerView
extends AbstractTemplateView {
    @Nullable
    private String encoding;
    @Nullable
    private Configuration configuration;

    public void setEncoding(@Nullable String encoding) {
        this.encoding = encoding;
    }

    public void setCharset(@Nullable Charset charset) {
        this.encoding = charset != null ? charset.name() : null;
    }

    @Nullable
    protected String getEncoding() {
        return this.encoding;
    }

    public void setConfiguration(@Nullable Configuration configuration) {
        this.configuration = configuration;
    }

    @Nullable
    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Configuration obtainConfiguration() {
        Configuration configuration = this.getConfiguration();
        Assert.state((configuration != null ? 1 : 0) != 0, (String)"No Configuration set");
        return configuration;
    }

    protected void initApplicationContext() {
        if (this.getConfiguration() == null) {
            FreeMarkerConfig config = this.autodetectConfiguration();
            this.setConfiguration(config.getConfiguration());
        }
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return (FreeMarkerConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((BeanFactory)this.obtainApplicationContext(), FreeMarkerConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
    }

    protected ObjectWrapper getObjectWrapper() {
        ObjectWrapper ow = this.obtainConfiguration().getObjectWrapper();
        return ow != null ? ow : new DefaultObjectWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS).build();
    }

    @Override
    public boolean checkResource(Locale locale) throws Exception {
        String url = this.getUrl();
        Assert.state((url != null ? 1 : 0) != 0, (String)"'url' not set");
        try {
            this.getTemplate(url, locale);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (ParseException ex) {
            throw new ApplicationContextException("Failed to parse [%s]".formatted(url), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Failed to load [%s]".formatted(url), (Throwable)ex);
        }
    }

    @Override
    protected void renderMergedTemplateModel(Map<String, Object> model, RequestContext context) throws Exception {
        this.exposeHelpers(model, context);
        this.doRender(model, context);
    }

    protected void exposeHelpers(Map<String, Object> model, RequestContext request) throws Exception {
    }

    protected void doRender(Map<String, Object> model, RequestContext context) throws Exception {
        this.exposeModelAsRequestAttributes(model, context);
        SimpleHash fmModel = this.buildTemplateModel(model, context);
        Locale locale = RequestContextUtils.getLocale(context);
        this.processTemplate(this.getTemplate(locale), fmModel, context);
    }

    protected SimpleHash buildTemplateModel(Map<String, Object> model, RequestContext request) {
        RequestHashModel fmModel = new RequestHashModel(this.getObjectWrapper(), request);
        fmModel.putAll(model);
        return fmModel;
    }

    protected Template getTemplate(Locale locale) throws IOException {
        String url = this.getUrl();
        Assert.state((url != null ? 1 : 0) != 0, (String)"'url' not set");
        return this.getTemplate(url, locale);
    }

    protected Template getTemplate(String name, Locale locale) throws IOException {
        String encoding = this.getEncoding();
        return encoding != null ? this.obtainConfiguration().getTemplate(name, locale, encoding) : this.obtainConfiguration().getTemplate(name, locale);
    }

    protected void processTemplate(Template template, SimpleHash model, RequestContext response) throws IOException, TemplateException {
        String encoding = this.getEncoding();
        if (encoding != null) {
            Environment env = template.createProcessingEnvironment((Object)model, (Writer)response.getWriter());
            env.setOutputEncoding(encoding);
            env.process();
        } else {
            template.process((Object)model, (Writer)response.getWriter());
        }
    }

    private static class RequestHashModel
    extends SimpleHash {
        private static final long serialVersionUID = 1L;
        private final RequestContext request;

        public RequestHashModel(ObjectWrapper wrapper, RequestContext request) {
            super(wrapper);
            this.request = request;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            TemplateModel model = super.get(key);
            if (model != null) {
                return model;
            }
            Object obj = this.request.getAttribute(key);
            if (obj != null) {
                return this.wrap(obj);
            }
            return this.wrap(null);
        }
    }
}

