/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.feed;

import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.WireFeedOutput;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.view.AbstractView;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public abstract class AbstractFeedView<T extends WireFeed>
extends AbstractView {
    @Override
    protected final void renderMergedOutputModel(Map<String, Object> model, RequestContext request) throws Exception {
        T wireFeed = this.newFeed();
        this.buildFeedMetadata(model, wireFeed, request);
        this.buildFeedEntries(model, wireFeed, request);
        this.setResponseContentType(request);
        if (StringUtils.isBlank((String)wireFeed.getEncoding())) {
            wireFeed.setEncoding("UTF-8");
        }
        WireFeedOutput feedOutput = new WireFeedOutput();
        OutputStream out = request.getOutputStream();
        feedOutput.output(wireFeed, (Writer)new OutputStreamWriter(out, wireFeed.getEncoding()));
        out.flush();
    }

    protected abstract T newFeed();

    protected void buildFeedMetadata(Map<String, Object> model, T feed, RequestContext request) {
    }

    protected abstract void buildFeedEntries(Map<String, Object> var1, T var2, RequestContext var3) throws Exception;
}

