/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.document;

import infra.web.RequestContext;
import infra.web.view.AbstractView;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractXlsView
extends AbstractView {
    public AbstractXlsView() {
        this.setContentType("application/vnd.ms-excel");
    }

    @Override
    protected boolean generatesDownloadContent() {
        return true;
    }

    @Override
    protected final void renderMergedOutputModel(Map<String, Object> model, RequestContext request) throws Exception {
        Workbook workbook = this.createWorkbook(model, request);
        this.buildExcelDocument(model, workbook, request);
        request.setContentType(this.getContentType());
        this.renderWorkbook(workbook, request);
    }

    protected Workbook createWorkbook(Map<String, Object> model, RequestContext request) {
        return new HSSFWorkbook();
    }

    protected void renderWorkbook(Workbook workbook, RequestContext response) throws IOException {
        OutputStream out = response.getOutputStream();
        workbook.write(out);
        workbook.close();
    }

    protected abstract void buildExcelDocument(Map<String, Object> var1, Workbook var2, RequestContext var3) throws Exception;
}

