/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.document;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import infra.web.RequestContext;
import infra.web.view.AbstractView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractPdfView
extends AbstractView {
    public AbstractPdfView() {
        this.setContentType("application/pdf");
    }

    @Override
    protected boolean generatesDownloadContent() {
        return true;
    }

    @Override
    protected final void renderMergedOutputModel(Map<String, Object> model, RequestContext request) throws Exception {
        ByteArrayOutputStream baos = this.createTemporaryOutputStream();
        Document document = this.newDocument();
        PdfWriter writer = this.newWriter(document, baos);
        this.prepareWriter(model, writer, request);
        this.buildPdfMetadata(model, document, request);
        document.open();
        this.buildPdfDocument(model, document, writer, request);
        document.close();
        this.writeToResponse(request, baos);
    }

    protected Document newDocument() {
        return new Document(PageSize.A4);
    }

    protected PdfWriter newWriter(Document document, OutputStream os) throws DocumentException {
        return PdfWriter.getInstance((Document)document, (OutputStream)os);
    }

    protected void prepareWriter(Map<String, Object> model, PdfWriter writer, RequestContext request) throws DocumentException {
        writer.setViewerPreferences(this.getViewerPreferences());
    }

    protected int getViewerPreferences() {
        return 2053;
    }

    protected void buildPdfMetadata(Map<String, Object> model, Document document, RequestContext request) {
    }

    protected abstract void buildPdfDocument(Map<String, Object> var1, Document var2, PdfWriter var3, RequestContext var4) throws Exception;
}

