/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view.document;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import infra.lang.Assert;
import infra.web.RequestContext;
import infra.web.view.AbstractUrlBasedView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractPdfStamperView
extends AbstractUrlBasedView {
    public AbstractPdfStamperView() {
        this.setContentType("application/pdf");
    }

    @Override
    protected boolean generatesDownloadContent() {
        return true;
    }

    @Override
    protected final void renderMergedOutputModel(Map<String, Object> model, RequestContext request) throws Exception {
        ByteArrayOutputStream baos = this.createTemporaryOutputStream();
        PdfReader reader = this.readPdfResource();
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)baos);
        this.mergePdfDocument(model, stamper, request);
        stamper.close();
        this.writeToResponse(request, baos);
    }

    protected PdfReader readPdfResource() throws IOException {
        String url = this.getUrl();
        Assert.state((url != null ? 1 : 0) != 0, (String)"'url' not set");
        return new PdfReader(this.obtainApplicationContext().getResource(url).getInputStream());
    }

    protected abstract void mergePdfDocument(Map<String, Object> var1, PdfStamper var2, RequestContext var3) throws Exception;
}

