/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.HandlerMatchingMetadata;
import infra.web.LocaleResolver;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.result.SmartReturnValueHandler;
import infra.web.view.ModelAndView;
import infra.web.view.View;
import infra.web.view.ViewRef;
import infra.web.view.ViewRenderingException;
import infra.web.view.ViewResolver;
import java.util.Locale;
import java.util.Map;

public class ViewReturnValueHandler
implements SmartReturnValueHandler {
    private final ViewResolver viewResolver;
    @Nullable
    private LocaleResolver localeResolver;

    public ViewReturnValueHandler(ViewResolver viewResolver) {
        this(viewResolver, null);
    }

    public ViewReturnValueHandler(ViewResolver viewResolver, @Nullable LocaleResolver localeResolver) {
        Assert.notNull((Object)viewResolver, (String)"viewResolver is required");
        this.viewResolver = viewResolver;
        this.localeResolver = localeResolver;
    }

    @Override
    public boolean supportsHandler(@Nullable Object handler, @Nullable Object returnValue) {
        HandlerMethod handlerMethod = HandlerMethod.unwrap(handler);
        if (handlerMethod != null) {
            Class<?> rawReturnType = handlerMethod.getRawReturnType();
            if (returnValue == null) {
                return ViewRef.class.isAssignableFrom(rawReturnType) || View.class.isAssignableFrom(rawReturnType) || ModelAndView.class.isAssignableFrom(rawReturnType);
            }
            if (rawReturnType.isInstance(returnValue) && CharSequence.class.isAssignableFrom(rawReturnType)) {
                return !handlerMethod.isResponseBody();
            }
        }
        return this.supportsReturnValue(returnValue);
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return returnValue instanceof CharSequence || returnValue instanceof View || returnValue instanceof ViewRef || returnValue instanceof ModelAndView;
    }

    @Override
    public void handleReturnValue(RequestContext context, @Nullable Object handler, @Nullable Object returnValue) throws ViewRenderingException {
        if (returnValue instanceof CharSequence) {
            CharSequence viewName = (CharSequence)returnValue;
            this.renderView(context, viewName);
        } else if (returnValue instanceof ViewRef) {
            ViewRef viewRef = (ViewRef)returnValue;
            this.renderView(context, viewRef);
        } else if (returnValue instanceof View) {
            View view = (View)returnValue;
            this.renderView(context, view);
        } else if (returnValue instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)returnValue;
            this.renderView(context, mv);
        } else if (returnValue != null) {
            throw new ViewRenderingException("Unsupported render result [%s] as view".formatted(returnValue));
        }
    }

    public void renderView(RequestContext request, @Nullable ModelAndView mv) throws ViewRenderingException {
        if (mv != null) {
            String viewName;
            if (mv.getStatus() != null) {
                request.setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, mv.getStatus());
                request.setStatus(mv.getStatus());
            }
            if ((viewName = mv.getViewName()) != null) {
                this.renderView(request, viewName, mv.getModel());
            } else {
                View view = mv.getView();
                if (view != null) {
                    this.renderView(request, view, mv.getModel());
                }
            }
        }
    }

    public void renderView(RequestContext context, CharSequence viewName) {
        this.renderView(context, viewName.toString());
    }

    public void renderView(RequestContext context, String viewName) {
        this.renderView(context, viewName, null);
    }

    public void renderView(RequestContext context, String viewName, @Nullable Map<String, Object> model) {
        View view = this.resolveViewName(context, viewName, null);
        this.renderView(context, view, model);
    }

    public void renderView(RequestContext context, ViewRef viewRef) {
        this.renderView(context, viewRef, null);
    }

    public void renderView(RequestContext context, ViewRef viewRef, @Nullable Map<String, Object> model) {
        View view = this.resolveViewName(context, viewRef.getViewName(), viewRef.getLocale());
        this.renderView(context, view, model);
    }

    private Locale getLocale(RequestContext request) {
        LocaleResolver localeResolver = this.localeResolver;
        if (localeResolver == null) {
            localeResolver = RequestContextUtils.getLocaleResolver(request);
        }
        if (localeResolver != null) {
            return localeResolver.resolveLocale(request);
        }
        return request.getLocale();
    }

    public void renderView(RequestContext context, View view) {
        this.renderView(context, view, null);
    }

    public void renderView(RequestContext context, View view, @Nullable Map<String, Object> model) {
        try {
            view.render(model, context);
        }
        catch (Exception e) {
            throw new ViewRenderingException("View '%s' render failed".formatted(view), (Throwable)e);
        }
    }

    public void setLocaleResolver(@Nullable LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Nullable
    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public ViewResolver getViewResolver() {
        return this.viewResolver;
    }

    private View resolveViewName(RequestContext context, String viewName, @Nullable Locale locale) {
        View view;
        if (locale == null) {
            locale = this.getLocale(context);
        }
        if ((view = this.resolveViewName(locale, viewName)) == null) {
            HandlerMatchingMetadata matchingMetadata = context.getMatchingMetadata();
            if (matchingMetadata != null) {
                Object handler = matchingMetadata.getHandler();
                throw new ViewRenderingException("Could not resolve view with name '%s' in handler '%s'".formatted(viewName, handler));
            }
            throw new ViewRenderingException("Could not resolve view with name '%s'".formatted(viewName));
        }
        return view;
    }

    @Nullable
    private View resolveViewName(Locale locale, String viewName) {
        try {
            return this.viewResolver.resolveViewName(viewName, locale);
        }
        catch (Exception e) {
            throw new ViewRenderingException("Could not resolve view with name '%s'".formatted(viewName), (Throwable)e);
        }
    }
}

