/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.beans.BeansException;
import infra.beans.factory.InitializingBean;
import infra.context.ApplicationContext;
import infra.context.ApplicationContextAware;
import infra.core.Ordered;
import infra.core.OrderedSupport;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.view.View;
import infra.web.view.ViewResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ViewResolverComposite
extends OrderedSupport
implements ViewResolver,
Ordered,
InitializingBean,
ApplicationContextAware {
    protected final ArrayList<ViewResolver> viewResolvers = new ArrayList();

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers.clear();
        if (CollectionUtils.isNotEmpty(viewResolvers)) {
            this.viewResolvers.addAll(viewResolvers);
            this.viewResolvers.trimToSize();
        }
    }

    public List<ViewResolver> getViewResolvers() {
        return this.viewResolvers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        for (ViewResolver viewResolver : this.viewResolvers) {
            if (!(viewResolver instanceof ApplicationContextAware)) continue;
            ((ApplicationContextAware)viewResolver).setApplicationContext(applicationContext);
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (ViewResolver viewResolver : this.viewResolvers) {
            if (!(viewResolver instanceof InitializingBean)) continue;
            ((InitializingBean)viewResolver).afterPropertiesSet();
        }
    }

    @Override
    @Nullable
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        for (ViewResolver viewResolver : this.viewResolvers) {
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view == null) continue;
            return view;
        }
        return null;
    }
}

