/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.beans.BeanUtils;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.StringUtils;
import infra.web.HandlerMatchingMetadata;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.util.UriUtils;
import infra.web.view.AbstractUrlBasedView;
import infra.web.view.SmartView;
import infra.web.view.View;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedirectView
extends AbstractUrlBasedView
implements SmartView {
    private static final Pattern URI_TEMPLATE_VARIABLE_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private boolean http10Compatible = true;
    private boolean exposeModelAttributes = true;
    @Nullable
    private Charset encoding;
    @Nullable
    private HttpStatusCode statusCode;
    private boolean expandUriTemplateVariables = true;
    private boolean propagateQueryParams = false;

    public RedirectView() {
        this.setExposePathVariables(false);
    }

    public RedirectView(String url) {
        super(url);
        this.setExposePathVariables(false);
    }

    public RedirectView(String url, boolean http10Compatible) {
        super(url);
        this.http10Compatible = http10Compatible;
        this.setExposePathVariables(false);
    }

    public RedirectView(String url, boolean http10Compatible, boolean exposeModelAttributes) {
        super(url);
        this.http10Compatible = http10Compatible;
        this.exposeModelAttributes = exposeModelAttributes;
        this.setExposePathVariables(false);
    }

    public void setHttp10Compatible(boolean http10Compatible) {
        this.http10Compatible = http10Compatible;
    }

    public void setExposeModelAttributes(boolean exposeModelAttributes) {
        this.exposeModelAttributes = exposeModelAttributes;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encoding = Charset.forName(encodingScheme);
    }

    public void setEncoding(@Nullable Charset charset) {
        this.encoding = charset;
    }

    public void setStatusCode(HttpStatusCode statusCode) {
        Assert.isTrue((boolean)statusCode.is3xxRedirection(), () -> "Not a redirect status code: " + statusCode);
        this.statusCode = statusCode;
    }

    public void setExpandUriTemplateVariables(boolean expandUriTemplateVariables) {
        this.expandUriTemplateVariables = expandUriTemplateVariables;
    }

    public void setPropagateQueryParams(boolean propagateQueryParams) {
        this.propagateQueryParams = propagateQueryParams;
    }

    public boolean isPropagateQueryProperties() {
        return this.propagateQueryParams;
    }

    @Override
    public boolean isRedirectView() {
        return true;
    }

    protected boolean isContextRequired() {
        return false;
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, RequestContext request) throws IOException {
        String targetUrl = this.createTargetUrl(model, request);
        RequestContextUtils.saveRedirectModel(targetUrl, request);
        this.sendRedirect(request, targetUrl);
    }

    protected final String createTargetUrl(Map<String, Object> model, RequestContext request) {
        StringBuilder targetUrl = new StringBuilder();
        String url = this.getUrl();
        Assert.state((url != null ? 1 : 0) != 0, (String)"'url' not set");
        targetUrl.append(url);
        Charset enc = this.encoding;
        if (enc == null) {
            enc = StandardCharsets.UTF_8;
        }
        if (this.expandUriTemplateVariables && StringUtils.hasText((CharSequence)targetUrl)) {
            Map<String, String> variables = this.getCurrentRequestUriVariables(request);
            targetUrl = this.replaceUriTemplateVariables(targetUrl.toString(), model, variables, enc);
        }
        if (this.isPropagateQueryProperties()) {
            this.appendCurrentQueryParams(targetUrl, request);
        }
        if (this.exposeModelAttributes) {
            this.appendQueryProperties(targetUrl, model, enc);
        }
        return targetUrl.toString();
    }

    protected StringBuilder replaceUriTemplateVariables(String targetUrl, Map<String, Object> model, Map<String, String> currentUriVariables, Charset encodingScheme) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = URI_TEMPLATE_VARIABLE_PATTERN.matcher(targetUrl);
        int endLastMatch = 0;
        while (matcher.find()) {
            Object value;
            String name = matcher.group(1);
            Object object = value = model.containsKey(name) ? model.remove(name) : currentUriVariables.get(name);
            if (value == null) {
                throw new IllegalArgumentException("Model has no value for key '" + name + "'");
            }
            result.append(targetUrl, endLastMatch, matcher.start());
            result.append(UriUtils.encodePathSegment(value.toString(), encodingScheme));
            endLastMatch = matcher.end();
        }
        result.append(targetUrl.substring(endLastMatch));
        return result;
    }

    private Map<String, String> getCurrentRequestUriVariables(RequestContext request) {
        HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
        if (matchingMetadata != null) {
            return matchingMetadata.getUriVariables();
        }
        return Collections.emptyMap();
    }

    protected void appendCurrentQueryParams(StringBuilder targetUrl, RequestContext request) {
        String query = request.getQueryString();
        if (StringUtils.hasText((String)query)) {
            String fragment = null;
            int anchorIndex = targetUrl.indexOf("#");
            if (anchorIndex > -1) {
                fragment = targetUrl.substring(anchorIndex);
                targetUrl.delete(anchorIndex, targetUrl.length());
            }
            if (targetUrl.toString().indexOf(63) < 0) {
                targetUrl.append('?').append(query);
            } else {
                targetUrl.append('&').append(query);
            }
            if (fragment != null) {
                targetUrl.append(fragment);
            }
        }
    }

    protected void appendQueryProperties(StringBuilder targetUrl, Map<String, Object> model, Charset encodingScheme) {
        String fragment = null;
        int anchorIndex = targetUrl.indexOf("#");
        if (anchorIndex > -1) {
            fragment = targetUrl.substring(anchorIndex);
            targetUrl.delete(anchorIndex, targetUrl.length());
        }
        boolean first = targetUrl.toString().indexOf(63) < 0;
        for (Map.Entry<String, Object> entry : this.queryProperties(model).entrySet()) {
            Object rawValue = entry.getValue();
            Collection<Object> values = rawValue != null && rawValue.getClass().isArray() ? CollectionUtils.arrayToList((Object)rawValue) : (rawValue instanceof Collection ? (Set<Object>)rawValue : Collections.singleton(rawValue));
            for (Object value : values) {
                if (first) {
                    targetUrl.append('?');
                    first = false;
                } else {
                    targetUrl.append('&');
                }
                String encodedKey = this.urlEncode(entry.getKey(), encodingScheme);
                targetUrl.append(encodedKey).append('=');
                if (value == null) continue;
                targetUrl.append(this.urlEncode(value.toString(), encodingScheme));
            }
        }
        if (fragment != null) {
            targetUrl.append(fragment);
        }
    }

    protected Map<String, Object> queryProperties(Map<String, Object> model) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            Object value;
            String name = entry.getKey();
            if (!this.isEligibleProperty(name, value = entry.getValue())) continue;
            result.put(name, value);
        }
        return result;
    }

    protected boolean isEligibleProperty(String key, @Nullable Object value) {
        if (value == null) {
            return false;
        }
        if (this.isEligibleValue(value)) {
            return true;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                if (this.isEligibleValue(element)) continue;
                return false;
            }
            return true;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            if (coll.isEmpty()) {
                return false;
            }
            for (Object element : coll) {
                if (this.isEligibleValue(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isEligibleValue(@Nullable Object value) {
        return value != null && BeanUtils.isSimpleValueType(value.getClass());
    }

    protected String urlEncode(String input, Charset encodingScheme) {
        return URLEncoder.encode(input, encodingScheme);
    }

    protected void sendRedirect(RequestContext context, String targetUrl) throws IOException {
        HttpStatusCode httpStatus = this.getHttpStatus(context, targetUrl);
        if (httpStatus != null) {
            context.setStatus(httpStatus);
            context.responseHeaders().setLocation(targetUrl);
        } else {
            context.sendRedirect(targetUrl);
        }
    }

    @Nullable
    protected HttpStatusCode getHttpStatus(RequestContext context, String targetUrl) {
        if (this.statusCode != null) {
            return this.statusCode;
        }
        Object attribute = context.getAttribute(View.RESPONSE_STATUS_ATTRIBUTE);
        if (attribute instanceof HttpStatusCode) {
            HttpStatusCode attributeStatusCode = (HttpStatusCode)attribute;
            return attributeStatusCode;
        }
        if (this.http10Compatible) {
            return null;
        }
        return HttpStatus.SEE_OTHER;
    }
}

