/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.InitializingBean;
import infra.beans.factory.config.AutowireCapableBeanFactory;
import infra.context.ApplicationContext;
import infra.context.support.ApplicationObjectSupport;
import infra.core.Ordered;
import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.http.HttpStatus;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MimeTypeUtils;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.HandlerMatchingMetadata;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.RequestContext;
import infra.web.RequestContextHolder;
import infra.web.accept.ContentNegotiationManager;
import infra.web.accept.ContentNegotiationManagerFactoryBean;
import infra.web.view.SmartView;
import infra.web.view.View;
import infra.web.view.ViewResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;

public class ContentNegotiatingViewResolver
extends ApplicationObjectSupport
implements ViewResolver,
Ordered,
InitializingBean {
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    private boolean useNotAcceptableStatusCode = false;
    @Nullable
    private List<View> defaultViews;
    @Nullable
    private List<ViewResolver> viewResolvers;
    private int order = Integer.MIN_VALUE;
    private static final View NOT_ACCEPTABLE_VIEW = (model, context) -> context.setStatus(HttpStatus.NOT_ACCEPTABLE);

    public void setContentNegotiationManager(@Nullable ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    @Nullable
    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setUseNotAcceptableStatusCode(boolean useNotAcceptableStatusCode) {
        this.useNotAcceptableStatusCode = useNotAcceptableStatusCode;
    }

    public boolean isUseNotAcceptableStatusCode() {
        return this.useNotAcceptableStatusCode;
    }

    public void setDefaultViews(@Nullable List<View> defaultViews) {
        this.defaultViews = defaultViews;
    }

    @Nullable
    public List<View> getDefaultViews() {
        return this.defaultViews;
    }

    public void setViewResolvers(@Nullable List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    @Nullable
    public List<ViewResolver> getViewResolvers() {
        return this.viewResolvers;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    protected void initApplicationContext() {
        ApplicationContext context = this.obtainApplicationContext();
        Collection matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((BeanFactory)context, ViewResolver.class).values();
        if (this.viewResolvers == null) {
            this.viewResolvers = new ArrayList<ViewResolver>(matchingBeans.size());
            for (ViewResolver viewResolver : matchingBeans) {
                if (this == viewResolver) continue;
                this.viewResolvers.add(viewResolver);
            }
        } else {
            AutowireCapableBeanFactory autowireCapableBeanFactory = context.getAutowireCapableBeanFactory();
            for (int i = 0; i < this.viewResolvers.size(); ++i) {
                ViewResolver vr = this.viewResolvers.get(i);
                if (matchingBeans.contains(vr)) continue;
                String name = vr.getClass().getName() + i;
                autowireCapableBeanFactory.initializeBean((Object)vr, name);
            }
        }
        AnnotationAwareOrderComparator.sort(this.viewResolvers);
    }

    public void afterPropertiesSet() {
        if (this.contentNegotiationManager == null) {
            this.contentNegotiationManager = new ContentNegotiationManagerFactoryBean().build();
        }
        if (CollectionUtils.isEmpty(this.viewResolvers)) {
            this.logger.warn("No ViewResolvers configured");
        }
    }

    @Override
    @Nullable
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        String mediaTypeInfo;
        List<View> candidateViews;
        View bestView;
        RequestContext context = RequestContextHolder.getRequired();
        List<MediaType> requestedMediaTypes = this.getMediaTypes(context);
        if (requestedMediaTypes != null && (bestView = this.getBestView(candidateViews = this.getCandidateViews(viewName, locale, requestedMediaTypes), requestedMediaTypes, context)) != null) {
            return bestView;
        }
        String string = mediaTypeInfo = this.logger.isDebugEnabled() && requestedMediaTypes != null ? " given " + requestedMediaTypes : "";
        if (this.useNotAcceptableStatusCode) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using 406 NOT_ACCEPTABLE {}", (Object)mediaTypeInfo);
            }
            return NOT_ACCEPTABLE_VIEW;
        }
        this.logger.debug("View remains unresolved {}", (Object)mediaTypeInfo);
        return null;
    }

    @Nullable
    protected List<MediaType> getMediaTypes(RequestContext context) {
        ContentNegotiationManager manager = this.getContentNegotiationManager();
        Assert.state((manager != null ? 1 : 0) != 0, (String)"No ContentNegotiationManager set");
        try {
            List<MediaType> acceptableMediaTypes = manager.resolveMediaTypes(context);
            MediaType[] producibleMediaTypes = this.getProducibleMediaTypes(context);
            LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
            for (MediaType acceptable : acceptableMediaTypes) {
                for (MediaType producible : producibleMediaTypes) {
                    if (!acceptable.isCompatibleWith(producible)) continue;
                    compatibleMediaTypes.add(this.getMostSpecificMediaType(acceptable, producible));
                }
            }
            ArrayList<MediaType> selectedMediaTypes = new ArrayList<MediaType>(compatibleMediaTypes);
            MimeTypeUtils.sortBySpecificity(selectedMediaTypes);
            return selectedMediaTypes;
        }
        catch (HttpMediaTypeNotAcceptableException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ex.getMessage());
            }
            return null;
        }
    }

    private MediaType[] getProducibleMediaTypes(RequestContext context) {
        Object[] mediaTypes;
        HandlerMatchingMetadata matchingMetadata = context.getMatchingMetadata();
        if (matchingMetadata != null && ObjectUtils.isNotEmpty((Object[])(mediaTypes = matchingMetadata.getProducibleMediaTypes()))) {
            return mediaTypes;
        }
        return new MediaType[]{MediaType.ALL};
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        if (acceptType.isLessSpecific(produceType = produceType.copyQualityValue(acceptType))) {
            return produceType;
        }
        return acceptType;
    }

    private List<View> getCandidateViews(String viewName, Locale locale, List<MediaType> requestedMediaTypes) throws Exception {
        ArrayList<View> candidateViews = new ArrayList<View>();
        if (this.viewResolvers != null) {
            ContentNegotiationManager negotiationManager = this.getContentNegotiationManager();
            Assert.state((negotiationManager != null ? 1 : 0) != 0, (String)"No ContentNegotiationManager set");
            for (ViewResolver viewResolver : this.viewResolvers) {
                View view = viewResolver.resolveViewName(viewName, locale);
                if (view != null) {
                    candidateViews.add(view);
                }
                for (MediaType requestedMediaType : requestedMediaTypes) {
                    List<String> extensions = negotiationManager.resolveFileExtensions(requestedMediaType);
                    for (String extension : extensions) {
                        String viewNameWithExtension = viewName + "." + extension;
                        view = viewResolver.resolveViewName(viewNameWithExtension, locale);
                        if (view == null) continue;
                        candidateViews.add(view);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(this.defaultViews)) {
            candidateViews.addAll(this.defaultViews);
        }
        return candidateViews;
    }

    @Nullable
    private View getBestView(List<View> candidateViews, List<MediaType> requestedMediaTypes, RequestContext context) {
        for (View candidateView : candidateViews) {
            SmartView smartView;
            if (!(candidateView instanceof SmartView) || !(smartView = (SmartView)candidateView).isRedirectView()) continue;
            return candidateView;
        }
        for (MediaType mediaType : requestedMediaTypes) {
            for (View candidateView : candidateViews) {
                MediaType candidateContentType;
                if (!StringUtils.hasText((String)candidateView.getContentType()) || !mediaType.isCompatibleWith(candidateContentType = MediaType.parseMediaType(candidateView.getContentType()))) continue;
                mediaType = mediaType.removeQualityValue();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Selected '{}' given {}", (Object)mediaType, requestedMediaTypes);
                }
                context.setAttribute(View.SELECTED_CONTENT_TYPE, mediaType);
                return candidateView;
            }
        }
        return null;
    }
}

