/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.lang.Nullable;
import infra.ui.ModelMap;
import infra.validation.BindingResult;
import java.util.Map;

public class BindingAwareModelMap
extends ModelMap {
    private static final long serialVersionUID = 1L;

    public Object put(String key, @Nullable Object value) {
        this.removeBindingResultIfNecessary(key, value);
        return super.put((Object)key, value);
    }

    public void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.removeBindingResultIfNecessary(entry.getKey(), entry.getValue());
        }
        super.putAll(map);
    }

    private void removeBindingResultIfNecessary(Object key, @Nullable Object value) {
        BindingResult bindingResult;
        String bindingResultKey;
        Object object;
        String attributeName;
        if (key instanceof String && !(attributeName = (String)key).startsWith(BindingResult.MODEL_KEY_PREFIX) && (object = this.get(bindingResultKey = BindingResult.MODEL_KEY_PREFIX + attributeName)) instanceof BindingResult && (bindingResult = (BindingResult)object).getTarget() != value) {
            this.remove(bindingResultKey);
        }
    }
}

