/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.beans.BeansException;
import infra.context.ApplicationContext;
import infra.context.support.ApplicationObjectSupport;
import infra.core.Ordered;
import infra.lang.Nullable;
import infra.web.view.View;
import infra.web.view.ViewResolver;
import java.util.Locale;

public class BeanNameViewResolver
extends ApplicationObjectSupport
implements ViewResolver,
Ordered {
    private int order = Integer.MAX_VALUE;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    @Nullable
    public View resolveViewName(String viewName, Locale locale) throws BeansException {
        ApplicationContext context = this.obtainApplicationContext();
        if (!context.containsBean(viewName)) {
            return null;
        }
        if (context.isTypeMatch(viewName, View.class)) {
            return (View)context.getBean(viewName, View.class);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found bean named '{}' but it does not implement View", (Object)viewName);
        }
        return null;
    }
}

