/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.beans.factory.BeanNameAware;
import infra.context.ApplicationContext;
import infra.context.support.ApplicationObjectSupport;
import infra.http.HttpHeaders;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.LogMessage;
import infra.logging.Logger;
import infra.util.CollectionUtils;
import infra.util.LogFormatUtils;
import infra.web.BindingContext;
import infra.web.ContextExposingRequestContext;
import infra.web.HandlerMatchingMetadata;
import infra.web.RedirectModel;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.view.View;
import infra.web.view.ViewRenderingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AbstractView
extends ApplicationObjectSupport
implements View,
BeanNameAware {
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 4096;
    @Nullable
    private String contentType = "text/html;charset=UTF-8";
    @Nullable
    private String requestContextAttribute;
    @Nullable
    private LinkedHashMap<String, Object> staticAttributes;
    private boolean exposePathVariables = true;
    private boolean exposeContextBeansAsAttributes = false;
    @Nullable
    private Set<String> exposedContextBeanNames;
    @Nullable
    private String beanName;
    private boolean exposeOutputRedirectModel = false;

    public void setContentType(@Nullable String contentType) {
        this.contentType = contentType;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public void setRequestContextAttribute(@Nullable String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    @Nullable
    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setAttributesCSV(@Nullable String propString) throws IllegalArgumentException {
        if (propString != null) {
            StringTokenizer st = new StringTokenizer(propString, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int eqIdx = tok.indexOf(61);
                if (eqIdx == -1) {
                    throw new IllegalArgumentException("Expected '=' in attributes CSV string '" + propString + "'");
                }
                if (eqIdx >= tok.length() - 2) {
                    throw new IllegalArgumentException("At least 2 characters ([]) required in attributes CSV string '" + propString + "'");
                }
                String name = tok.substring(0, eqIdx);
                int beginIndex = eqIdx + 2;
                int endIndex = tok.length() - 1;
                String value = tok.substring(beginIndex, endIndex);
                this.addStaticAttribute(name, value);
            }
        }
    }

    public void setAttributes(Properties attributes) {
        CollectionUtils.mergePropertiesIntoMap((Properties)attributes, this.staticAttributes());
    }

    private LinkedHashMap<String, Object> staticAttributes() {
        LinkedHashMap<String, Object> staticAttributes = this.staticAttributes;
        if (staticAttributes == null) {
            this.staticAttributes = staticAttributes = new LinkedHashMap();
        }
        return staticAttributes;
    }

    public void setAttributesMap(@Nullable Map<String, ?> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                this.addStaticAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<String, Object> getAttributesMap() {
        return this.staticAttributes();
    }

    public void addStaticAttribute(String name, Object value) {
        this.staticAttributes().put(name, value);
    }

    @Nullable
    public Map<String, Object> getStaticAttributes() {
        return this.staticAttributes;
    }

    public void setExposePathVariables(boolean exposePathVariables) {
        this.exposePathVariables = exposePathVariables;
    }

    public boolean isExposePathVariables() {
        return this.exposePathVariables;
    }

    public void setExposeContextBeansAsAttributes(boolean exposeContextBeansAsAttributes) {
        this.exposeContextBeansAsAttributes = exposeContextBeansAsAttributes;
    }

    public void setExposedContextBeanNames(String ... exposedContextBeanNames) {
        this.exposedContextBeanNames = Set.of(exposedContextBeanNames);
    }

    public void setBeanName(@Nullable String beanName) {
        this.beanName = beanName;
    }

    @Nullable
    public String getBeanName() {
        return this.beanName;
    }

    public void setExposeOutputRedirectModel(boolean exposeOutputRedirectModel) {
        this.exposeOutputRedirectModel = exposeOutputRedirectModel;
    }

    @Override
    public void render(@Nullable Map<String, ?> model, RequestContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            LogFormatUtils.traceDebug((Logger)this.logger, traceOn -> LogFormatUtils.formatValue((Object)LogMessage.format((String)"View {}, model {} {}", (Object)this.formatViewName(), model != null ? model : Collections.emptyMap(), (Object)(CollectionUtils.isEmpty(this.staticAttributes) ? "" : ", static attributes " + this.staticAttributes)), (traceOn == false ? 1 : 0) != 0));
        }
        Map<String, Object> mergedModel = this.createMergedOutputModel(model, context);
        this.prepareResponse(context);
        this.renderMergedOutputModel(mergedModel, this.getRequestContextToExpose(context));
    }

    protected Map<String, Object> createMergedOutputModel(@Nullable Map<String, ?> model, RequestContext context) {
        BindingContext binding;
        RedirectModel output;
        HandlerMatchingMetadata metadata;
        int size;
        Map<String, Object> staticAttributes = this.getStaticAttributes();
        int n = size = model != null ? model.size() : 0;
        if (staticAttributes != null) {
            size += staticAttributes.size();
        }
        Map<String, Object> pathVars = null;
        if (this.exposePathVariables && (metadata = context.getMatchingMetadata()) != null && metadata.hasPathVariables()) {
            pathVars = metadata.getPathVariables();
            size += pathVars.size();
        }
        LinkedHashMap mergedModel = CollectionUtils.newLinkedHashMap((int)size);
        if (CollectionUtils.isNotEmpty(staticAttributes)) {
            mergedModel.putAll(staticAttributes);
        }
        if (CollectionUtils.isNotEmpty(pathVars)) {
            mergedModel.putAll(pathVars);
        }
        if (CollectionUtils.isNotEmpty(model)) {
            mergedModel.putAll(model);
        }
        if (this.requestContextAttribute != null) {
            mergedModel.put(this.requestContextAttribute, context);
        }
        if (this.exposeOutputRedirectModel && (output = RequestContextUtils.getOutputRedirectModel(context)) != null) {
            mergedModel.putAll(output.asMap());
        }
        if ((binding = context.getBinding()) != null) {
            try {
                binding.updateModel(context);
            }
            catch (Throwable e) {
                throw new ViewRenderingException("View model update failed", e);
            }
            if (binding.hasModel()) {
                mergedModel.putAll(binding.getModel());
            }
        }
        return mergedModel;
    }

    protected void prepareResponse(RequestContext context) {
        if (this.generatesDownloadContent()) {
            HttpHeaders headers = context.responseHeaders();
            headers.setPragma("private");
            headers.setCacheControl("private, must-revalidate");
        }
    }

    protected boolean generatesDownloadContent() {
        return false;
    }

    protected RequestContext getRequestContextToExpose(RequestContext original) {
        if (this.exposeContextBeansAsAttributes || this.exposedContextBeanNames != null) {
            ApplicationContext wac = this.getApplicationContext();
            Assert.state((wac != null ? 1 : 0) != 0, (String)"No ApplicationContext");
            return new ContextExposingRequestContext(original, wac, this.exposedContextBeanNames);
        }
        return original;
    }

    protected abstract void renderMergedOutputModel(Map<String, Object> var1, RequestContext var2) throws Exception;

    protected void exposeModelAsRequestAttributes(Map<String, Object> model, RequestContext request) throws Exception {
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value != null) {
                request.setAttribute(name, value);
                continue;
            }
            request.removeAttribute(name);
        }
    }

    protected ByteArrayOutputStream createTemporaryOutputStream() {
        return new ByteArrayOutputStream(4096);
    }

    protected void writeToResponse(RequestContext response, ByteArrayOutputStream baos) throws IOException {
        response.setContentType(this.getContentType());
        response.setContentLength(baos.size());
        OutputStream out = response.getOutputStream();
        baos.writeTo(out);
        out.flush();
    }

    protected void setResponseContentType(RequestContext context) {
        MediaType mediaType;
        Object object = context.getAttribute(View.SELECTED_CONTENT_TYPE);
        if (object instanceof MediaType && (mediaType = (MediaType)object).isConcrete()) {
            context.setContentType(mediaType.toString());
        } else {
            context.setContentType(this.getContentType());
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.formatViewName();
    }

    protected String formatViewName() {
        return this.getBeanName() != null ? "name [%s]".formatted(this.getBeanName()) : "[%s]".formatted(this.getClass().getSimpleName());
    }
}

