/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.session.SessionManager;
import infra.session.WebSession;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.view.AbstractUrlBasedView;
import infra.web.view.ViewRenderingException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractTemplateView
extends AbstractUrlBasedView {
    private boolean exposeRequestAttributes = false;
    private boolean allowRequestOverride = false;
    private boolean exposeSessionAttributes = false;
    private boolean allowSessionOverride = false;

    public void setExposeRequestAttributes(boolean exposeRequestAttributes) {
        this.exposeRequestAttributes = exposeRequestAttributes;
    }

    public void setAllowRequestOverride(boolean allowRequestOverride) {
        this.allowRequestOverride = allowRequestOverride;
    }

    public void setExposeSessionAttributes(boolean exposeSessionAttributes) {
        this.exposeSessionAttributes = exposeSessionAttributes;
    }

    public void setAllowSessionOverride(boolean allowSessionOverride) {
        this.allowSessionOverride = allowSessionOverride;
    }

    @Override
    protected final void renderMergedOutputModel(Map<String, Object> model, RequestContext request) throws Exception {
        if (this.exposeRequestAttributes) {
            LinkedHashMap<String, Object> exposed = null;
            for (String attribute : request.attributeNames()) {
                if (model.containsKey(attribute) && !this.allowRequestOverride) {
                    throw new ViewRenderingException("Cannot expose request attribute '%s' because of an existing model object of the same name".formatted(attribute));
                }
                Object attributeValue = request.getAttribute(attribute);
                if (this.logger.isDebugEnabled()) {
                    exposed = exposed != null ? exposed : new LinkedHashMap<String, Object>();
                    exposed.put(attribute, attributeValue);
                }
                model.put(attribute, attributeValue);
            }
            if (exposed != null && this.logger.isTraceEnabled()) {
                this.logger.trace("Exposed request attributes to model: {}", exposed);
            }
        }
        if (this.exposeSessionAttributes) {
            this.exposeSessionAttributes(model, request);
        }
        this.applyContentType(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rendering [{}]", (Object)this.getUrl());
        }
        this.renderMergedTemplateModel(model, request);
    }

    private void exposeSessionAttributes(Map<String, Object> model, RequestContext context) {
        WebSession session;
        SessionManager sessionManager = RequestContextUtils.getSessionManager(context);
        if (sessionManager != null && (session = sessionManager.getSession(context, false)) != null) {
            String[] attributeNames;
            LinkedHashMap<String, Object> exposed = null;
            for (String attribute : attributeNames = session.getAttributeNames()) {
                if (model.containsKey(attribute) && !this.allowSessionOverride) {
                    throw new ViewRenderingException("Cannot expose session attribute '%s' because of an existing model object of the same name".formatted(attribute));
                }
                Object attributeValue = session.getAttribute(attribute);
                if (this.logger.isDebugEnabled()) {
                    exposed = exposed != null ? exposed : new LinkedHashMap<String, Object>();
                    exposed.put(attribute, attributeValue);
                }
                model.put(attribute, attributeValue);
            }
            if (this.logger.isTraceEnabled() && exposed != null) {
                this.logger.trace("Exposed session attributes to model: {}", exposed);
            }
        }
    }

    protected void applyContentType(RequestContext response) {
        if (response.getResponseContentType() == null) {
            response.setContentType(this.getContentType());
        }
    }

    protected abstract void renderMergedTemplateModel(Map<String, Object> var1, RequestContext var2) throws Exception;
}

