/*
 * Decompiled with CFR 0.152.
 */
package infra.web.view;

import infra.context.support.ApplicationObjectSupport;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.view.View;
import infra.web.view.ViewResolver;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCachingViewResolver
extends ApplicationObjectSupport
implements ViewResolver {
    public static final int DEFAULT_CACHE_LIMIT = 1024;
    public static final View UNRESOLVED_VIEW = (model, context) -> {};
    public static final CacheFilter DEFAULT_CACHE_FILTER = (view, viewName, locale) -> true;
    private volatile int cacheLimit = 1024;
    private boolean cacheUnresolved = true;
    private CacheFilter cacheFilter = DEFAULT_CACHE_FILTER;
    private final ConcurrentHashMap<Object, View> viewAccessCache = new ConcurrentHashMap(1024);
    private final LinkedHashMap<Object, View> viewCreationCache = new LinkedHashMap<Object, View>(1024, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, View> eldest) {
            if (this.size() > AbstractCachingViewResolver.this.getCacheLimit()) {
                AbstractCachingViewResolver.this.viewAccessCache.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    };

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setCache(boolean cache) {
        this.cacheLimit = cache ? 1024 : 0;
    }

    public boolean isCache() {
        return this.cacheLimit > 0;
    }

    public void setCacheUnresolved(boolean cacheUnresolved) {
        this.cacheUnresolved = cacheUnresolved;
    }

    public boolean isCacheUnresolved() {
        return this.cacheUnresolved;
    }

    public void setCacheFilter(CacheFilter cacheFilter) {
        Assert.notNull((Object)cacheFilter, (String)"CacheFilter is required");
        this.cacheFilter = cacheFilter;
    }

    public CacheFilter getCacheFilter() {
        return this.cacheFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        if (this.isCache()) {
            Object cacheKey = this.getCacheKey(viewName, locale);
            View view = this.viewAccessCache.get(cacheKey);
            if (view == null) {
                LinkedHashMap<Object, View> linkedHashMap = this.viewCreationCache;
                synchronized (linkedHashMap) {
                    view = this.viewCreationCache.get(cacheKey);
                    if (view == null) {
                        view = this.createView(viewName, locale);
                        if (view == null && this.cacheUnresolved) {
                            view = UNRESOLVED_VIEW;
                        }
                        if (view != null && this.cacheFilter.shouldCaching(view, viewName, locale)) {
                            this.viewAccessCache.put(cacheKey, view);
                            this.viewCreationCache.put(cacheKey, view);
                        }
                    }
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("{}served from cache", (Object)AbstractCachingViewResolver.formatKey(cacheKey));
            }
            return view != UNRESOLVED_VIEW ? view : null;
        }
        return this.createView(viewName, locale);
    }

    private static String formatKey(Object cacheKey) {
        return "View with key [" + cacheKey + "] ";
    }

    protected Object getCacheKey(String viewName, Locale locale) {
        return viewName + "_" + locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String viewName, Locale locale) {
        if (!this.isCache()) {
            this.logger.warn("Caching is OFF (removal not necessary)");
        } else {
            Object cachedView;
            Object cacheKey = this.getCacheKey(viewName, locale);
            LinkedHashMap<Object, View> linkedHashMap = this.viewCreationCache;
            synchronized (linkedHashMap) {
                this.viewAccessCache.remove(cacheKey);
                cachedView = this.viewCreationCache.remove(cacheKey);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(AbstractCachingViewResolver.formatKey(cacheKey) + (cachedView != null ? "cleared from cache" : "not found in the cache"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.debug("Clearing all views from the cache");
        LinkedHashMap<Object, View> linkedHashMap = this.viewCreationCache;
        synchronized (linkedHashMap) {
            this.viewAccessCache.clear();
            this.viewCreationCache.clear();
        }
    }

    @Nullable
    protected View createView(String viewName, Locale locale) throws Exception {
        return this.loadView(viewName, locale);
    }

    @Nullable
    protected abstract View loadView(String var1, Locale var2) throws Exception;

    @FunctionalInterface
    public static interface CacheFilter {
        public boolean shouldCaching(View var1, String var2, Locale var3);
    }
}

