/*
 * Decompiled with CFR 0.152.
 */
package infra.web.util.pattern;

import infra.http.server.PathContainer;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.RouteMatcher;
import infra.web.util.pattern.PathMatchInfo;
import infra.web.util.pattern.PathPattern;
import infra.web.util.pattern.PathPatternParser;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PathPatternRouteMatcher
implements RouteMatcher {
    private final PathPatternParser parser;
    private final ConcurrentHashMap<String, PathPattern> pathPatternCache = new ConcurrentHashMap();

    public PathPatternRouteMatcher() {
        this.parser = new PathPatternParser();
        this.parser.setPathOptions(PathContainer.Options.MESSAGE_ROUTE);
        this.parser.setMatchOptionalTrailingSeparator(false);
    }

    public PathPatternRouteMatcher(PathPatternParser parser) {
        Assert.notNull((Object)parser, (String)"PathPatternParser is required");
        this.parser = parser;
    }

    public RouteMatcher.Route parseRoute(String routeValue) {
        return new PathContainerRoute(PathContainer.parsePath(routeValue, this.parser.getPathOptions()));
    }

    public boolean isPattern(String route) {
        return this.getPathPattern(route).hasPatternSyntax();
    }

    public String combine(String pattern1, String pattern2) {
        return this.getPathPattern(pattern1).combine(this.getPathPattern(pattern2)).getPatternString();
    }

    public boolean match(String pattern, RouteMatcher.Route route) {
        return this.getPathPattern(pattern).matches(this.getPathContainer(route));
    }

    @Nullable
    public Map<String, String> matchAndExtract(String pattern, RouteMatcher.Route route) {
        PathMatchInfo info = this.getPathPattern(pattern).matchAndExtract(this.getPathContainer(route));
        return info != null ? info.getUriVariables() : null;
    }

    public Comparator<String> getPatternComparator(RouteMatcher.Route route) {
        return Comparator.comparing(this::getPathPattern);
    }

    private PathPattern getPathPattern(String pattern) {
        return this.pathPatternCache.computeIfAbsent(pattern, this.parser::parse);
    }

    private PathContainer getPathContainer(RouteMatcher.Route route) {
        Assert.isInstanceOf(PathContainerRoute.class, (Object)route);
        return ((PathContainerRoute)route).pathContainer;
    }

    private record PathContainerRoute(PathContainer pathContainer) implements RouteMatcher.Route
    {
        public String value() {
            return this.pathContainer.value();
        }

        @Override
        public String toString() {
            return this.value();
        }
    }
}

