/*
 * Decompiled with CFR 0.152.
 */
package infra.web.util.pattern;

import infra.http.server.PathContainer;
import infra.web.util.pattern.InternalPathPatternParser;
import infra.web.util.pattern.PathPattern;
import infra.web.util.pattern.PatternParseException;

public class PathPatternParser {
    private boolean caseSensitive = true;
    private boolean matchOptionalTrailingSeparator = true;
    private PathContainer.Options pathOptions = PathContainer.Options.HTTP_PATH;
    public static final PathPatternParser defaultInstance = new PathPatternParser(){

        @Override
        public void setMatchOptionalTrailingSeparator(boolean matchOptionalTrailingSeparator) {
            this.raiseError();
        }

        @Override
        public void setCaseSensitive(boolean caseSensitive) {
            this.raiseError();
        }

        @Override
        public void setPathOptions(PathContainer.Options pathOptions) {
            this.raiseError();
        }

        private void raiseError() {
            throw new UnsupportedOperationException("This is a read-only, shared instance that cannot be modified");
        }
    };

    public void setMatchOptionalTrailingSeparator(boolean matchOptionalTrailingSeparator) {
        this.matchOptionalTrailingSeparator = matchOptionalTrailingSeparator;
    }

    public boolean isMatchOptionalTrailingSeparator() {
        return this.matchOptionalTrailingSeparator;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setPathOptions(PathContainer.Options pathOptions) {
        this.pathOptions = pathOptions;
    }

    public PathContainer.Options getPathOptions() {
        return this.pathOptions;
    }

    public PathPattern parse(String pathPattern) throws PatternParseException {
        return new InternalPathPatternParser(this).parse(pathPattern);
    }
}

