/*
 * Decompiled with CFR 0.152.
 */
package infra.web.util.pattern;

import infra.http.server.PathContainer;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.util.pattern.CaptureTheRestPathElement;
import infra.web.util.pattern.PathElement;
import infra.web.util.pattern.PathMatchInfo;
import infra.web.util.pattern.PathPatternParser;
import infra.web.util.pattern.SeparatorPathElement;
import infra.web.util.pattern.VariableNameProvider;
import infra.web.util.pattern.WildcardPathElement;
import infra.web.util.pattern.WildcardTheRestPathElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class PathPattern
implements Comparable<PathPattern> {
    private static final PathContainer EMPTY_PATH = PathContainer.empty();
    public static final Comparator<PathPattern> SPECIFICITY_COMPARATOR = Comparator.nullsLast(Comparator.comparingInt(p -> p.catchAll ? 1 : 0).thenComparingInt(p -> p.catchAll ? PathPattern.scoreByNormalizedLength(p) : 0).thenComparingInt(PathPattern::getScore).thenComparingInt(PathPattern::scoreByNormalizedLength));
    private final String patternString;
    private final PathPatternParser parser;
    private final PathContainer.Options pathOptions;
    private final boolean matchOptionalTrailingSeparator;
    private final boolean caseSensitive;
    @Nullable
    private final PathElement head;
    private int capturedVariableCount;
    private int normalizedLength;
    private boolean endsWithSeparatorWildcard = false;
    private int score;
    private boolean catchAll = false;
    @Nullable
    private ArrayList<String> variableNames;

    PathPattern(String patternText, PathPatternParser parser, @Nullable PathElement head) {
        this.head = head;
        this.parser = parser;
        this.patternString = patternText;
        this.pathOptions = parser.getPathOptions();
        this.caseSensitive = parser.isCaseSensitive();
        this.matchOptionalTrailingSeparator = parser.isMatchOptionalTrailingSeparator();
        PathElement elem = head;
        while (elem != null) {
            this.capturedVariableCount += elem.getCaptureCount();
            this.normalizedLength += elem.getNormalizedLength();
            this.score += elem.getScore();
            if (elem instanceof CaptureTheRestPathElement || elem instanceof WildcardTheRestPathElement) {
                this.catchAll = true;
            }
            if (elem instanceof SeparatorPathElement && elem.next instanceof WildcardPathElement && elem.next.next == null) {
                this.endsWithSeparatorWildcard = true;
            }
            elem = elem.next;
        }
    }

    public String getPatternString() {
        return this.patternString;
    }

    public boolean hasPatternSyntax() {
        return this.score > 0 || this.catchAll || this.patternString.indexOf(63) != -1;
    }

    public boolean matches(PathContainer pathContainer) {
        if (this.head == null) {
            return !this.hasLength(pathContainer) || this.matchOptionalTrailingSeparator && this.pathContainerIsJustSeparator(pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                pathContainer = EMPTY_PATH;
            } else {
                return false;
            }
        }
        MatchingContext matchingContext = new MatchingContext(pathContainer, false);
        return this.head.matches(0, matchingContext);
    }

    @Nullable
    public PathMatchInfo matchAndExtract(PathContainer pathContainer) {
        MatchingContext matchingContext;
        if (this.head == null) {
            return this.hasLength(pathContainer) && (!this.matchOptionalTrailingSeparator || !this.pathContainerIsJustSeparator(pathContainer)) ? null : PathMatchInfo.EMPTY;
        }
        if (!this.hasLength(pathContainer)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                pathContainer = EMPTY_PATH;
            } else {
                return null;
            }
        }
        return this.head.matches(0, matchingContext = new MatchingContext(pathContainer, true)) ? matchingContext.getPathMatchResult() : null;
    }

    @Nullable
    public PathRemainingMatchInfo matchStartOfPath(PathContainer pathContainer) {
        PathContainer pathRemaining;
        PathContainer pathMatched;
        if (this.head == null) {
            return new PathRemainingMatchInfo(EMPTY_PATH, pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            return null;
        }
        MatchingContext matchingContext = new MatchingContext(pathContainer, true);
        matchingContext.setMatchAllowExtraPath();
        boolean matches = this.head.matches(0, matchingContext);
        if (!matches) {
            return null;
        }
        if (matchingContext.remainingPathIndex == pathContainer.elements().size()) {
            pathMatched = pathContainer;
            pathRemaining = EMPTY_PATH;
        } else {
            pathMatched = pathContainer.subPath(0, matchingContext.remainingPathIndex);
            pathRemaining = pathContainer.subPath(matchingContext.remainingPathIndex);
        }
        return new PathRemainingMatchInfo(pathMatched, pathRemaining, matchingContext.getPathMatchResult());
    }

    public PathContainer extractPathWithinPattern(PathContainer path) {
        PathContainer resultPath;
        int endIndex;
        List<PathContainer.Element> pathElements = path.elements();
        int pathElementsCount = pathElements.size();
        int startIndex = 0;
        PathElement elem = this.head;
        while (elem != null && elem.isLiteral()) {
            elem = elem.next;
            ++startIndex;
        }
        if (elem == null) {
            return EMPTY_PATH;
        }
        while (startIndex < pathElementsCount && pathElements.get(startIndex) instanceof PathContainer.Separator) {
            ++startIndex;
        }
        for (endIndex = pathElements.size(); endIndex > 0 && pathElements.get(endIndex - 1) instanceof PathContainer.Separator; --endIndex) {
        }
        boolean multipleAdjacentSeparators = false;
        for (int i = startIndex; i < endIndex - 1; ++i) {
            if (!(pathElements.get(i) instanceof PathContainer.Separator) || !(pathElements.get(i + 1) instanceof PathContainer.Separator)) continue;
            multipleAdjacentSeparators = true;
            break;
        }
        if (multipleAdjacentSeparators) {
            StringBuilder sb = new StringBuilder();
            int i = startIndex;
            while (i < endIndex) {
                PathContainer.Element e = pathElements.get(i++);
                sb.append(e.value());
                if (!(e instanceof PathContainer.Separator)) continue;
                while (i < endIndex && pathElements.get(i) instanceof PathContainer.Separator) {
                    ++i;
                }
            }
            resultPath = PathContainer.parsePath(sb.toString(), this.pathOptions);
        } else {
            resultPath = startIndex >= endIndex ? EMPTY_PATH : path.subPath(startIndex, endIndex);
        }
        return resultPath;
    }

    public ArrayList<String> getVariableNames() {
        if (this.variableNames == null) {
            this.variableNames = new ArrayList();
            PathElement current = this.head;
            while (current != null) {
                if (current instanceof VariableNameProvider) {
                    VariableNameProvider provider = (VariableNameProvider)((Object)current);
                    String variableName = provider.getVariableName();
                    this.variableNames.add(variableName);
                }
                current = current.next;
            }
        }
        return this.variableNames;
    }

    @Override
    public int compareTo(@Nullable PathPattern otherPattern) {
        int result = SPECIFICITY_COMPARATOR.compare(this, otherPattern);
        return result == 0 && otherPattern != null ? this.patternString.compareTo(otherPattern.patternString) : result;
    }

    public PathPattern combine(PathPattern pattern2string) {
        boolean secondExtensionWild;
        if (StringUtils.isEmpty((CharSequence)this.patternString)) {
            if (StringUtils.isEmpty((CharSequence)pattern2string.patternString)) {
                return this.parser.parse("");
            }
            return pattern2string;
        }
        if (StringUtils.isEmpty((CharSequence)pattern2string.patternString)) {
            return this;
        }
        if (this.capturedVariableCount == 0 && !this.patternString.equals(pattern2string.patternString) && this.matches(PathContainer.parsePath(pattern2string.patternString))) {
            return pattern2string;
        }
        if (this.endsWithSeparatorWildcard) {
            return this.parser.parse(this.concat(this.patternString.substring(0, this.patternString.length() - 2), pattern2string.patternString));
        }
        int starDotPos1 = this.patternString.indexOf("*.");
        if (this.capturedVariableCount != 0 || starDotPos1 == -1 || this.getSeparator() == '.') {
            return this.parser.parse(this.concat(this.patternString, pattern2string.patternString));
        }
        String firstExtension = this.patternString.substring(starDotPos1 + 1);
        String p2string = pattern2string.patternString;
        int dotPos2 = p2string.indexOf(46);
        String file2 = dotPos2 == -1 ? p2string : p2string.substring(0, dotPos2);
        String secondExtension = dotPos2 == -1 ? "" : p2string.substring(dotPos2);
        boolean firstExtensionWild = firstExtension.equals(".*") || firstExtension.isEmpty();
        boolean bl = secondExtensionWild = secondExtension.equals(".*") || secondExtension.isEmpty();
        if (!firstExtensionWild && !secondExtensionWild) {
            throw new IllegalArgumentException("Cannot combine patterns: " + this.patternString + " and " + pattern2string);
        }
        return this.parser.parse(file2 + (firstExtensionWild ? secondExtension : firstExtension));
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PathPattern) {
            PathPattern otherPattern = (PathPattern)other;
            return this.caseSensitive == otherPattern.caseSensitive && this.getSeparator() == otherPattern.getSeparator() && this.patternString.equals(otherPattern.getPatternString());
        }
        return false;
    }

    public int hashCode() {
        return (this.patternString.hashCode() + this.getSeparator()) * 17 + (this.caseSensitive ? 1 : 0);
    }

    public String toString() {
        return this.patternString;
    }

    int getScore() {
        return this.score;
    }

    boolean isCatchAll() {
        return this.catchAll;
    }

    int getNormalizedLength() {
        return this.normalizedLength;
    }

    char getSeparator() {
        return this.pathOptions.separator();
    }

    int getCapturedVariableCount() {
        return this.capturedVariableCount;
    }

    String toChainString() {
        StringJoiner stringJoiner = new StringJoiner(" ");
        PathElement pe = this.head;
        while (pe != null) {
            stringJoiner.add(pe.toString());
            pe = pe.next;
        }
        return stringJoiner.toString();
    }

    String computePatternString() {
        StringBuilder sb = new StringBuilder();
        PathElement pe = this.head;
        while (pe != null) {
            sb.append(pe.getChars());
            pe = pe.next;
        }
        return sb.toString();
    }

    @Nullable
    PathElement getHeadSection() {
        return this.head;
    }

    private String concat(String path1, String path2) {
        boolean path2StartsWithSeparator;
        boolean path1EndsWithSeparator = path1.charAt(path1.length() - 1) == this.getSeparator();
        boolean bl = path2StartsWithSeparator = path2.charAt(0) == this.getSeparator();
        if (path1EndsWithSeparator && path2StartsWithSeparator) {
            return path1 + path2.substring(1);
        }
        if (path1EndsWithSeparator || path2StartsWithSeparator) {
            return path1 + path2;
        }
        return path1 + this.getSeparator() + path2;
    }

    private boolean hasLength(@Nullable PathContainer container) {
        return container != null && !container.elements().isEmpty();
    }

    private static int scoreByNormalizedLength(PathPattern pattern) {
        return -pattern.normalizedLength;
    }

    private boolean pathContainerIsJustSeparator(PathContainer pathContainer) {
        return pathContainer.value().length() == 1 && pathContainer.value().charAt(0) == this.getSeparator();
    }

    class MatchingContext {
        public final PathContainer candidate;
        public final List<PathContainer.Element> pathElements;
        public final int pathLength;
        @Nullable
        private Map<String, String> extractedUriVariables;
        @Nullable
        private Map<String, MultiValueMap<String, String>> extractedMatrixVariables;
        public boolean extractingVariables;
        public boolean determineRemainingPath = false;
        public int remainingPathIndex;
        @Nullable
        public List<String> uriVariables;

        public MatchingContext(PathContainer pathContainer, boolean extractVariables) {
            this.candidate = pathContainer;
            this.pathElements = pathContainer.elements();
            this.pathLength = this.pathElements.size();
            this.extractingVariables = extractVariables;
        }

        public void setMatchAllowExtraPath() {
            this.determineRemainingPath = true;
        }

        public boolean isMatchOptionalTrailingSeparator() {
            return PathPattern.this.matchOptionalTrailingSeparator;
        }

        public void set(String key, String value, @Nullable MultiValueMap<String, String> parameters) {
            if (this.extractedUriVariables == null) {
                this.extractedUriVariables = new HashMap<String, String>();
            }
            this.extractedUriVariables.put(key, value);
            if (this.uriVariables == null) {
                this.uriVariables = new ArrayList<String>();
            }
            this.uriVariables.add(value);
            if (CollectionUtils.isNotEmpty(parameters)) {
                if (this.extractedMatrixVariables == null) {
                    this.extractedMatrixVariables = new HashMap<String, MultiValueMap<String, String>>();
                }
                this.extractedMatrixVariables.put(key, (MultiValueMap<String, String>)parameters.asReadOnly());
            }
        }

        public PathMatchInfo getPathMatchResult() {
            if (this.extractedUriVariables == null) {
                return PathMatchInfo.EMPTY;
            }
            return new PathMatchInfo(this.extractedUriVariables, this.extractedMatrixVariables);
        }

        public boolean isSeparator(int pathIndex) {
            return this.pathElements.get(pathIndex) instanceof PathContainer.Separator;
        }

        public String pathElementValue(int pathIndex) {
            String string;
            PathContainer.Element element;
            PathContainer.Element element2 = element = pathIndex < this.pathLength ? this.pathElements.get(pathIndex) : null;
            if (element instanceof PathContainer.PathSegment) {
                PathContainer.PathSegment pathSegment = (PathContainer.PathSegment)element;
                string = pathSegment.valueToMatch();
            } else {
                string = "";
            }
            return string;
        }
    }

    public static class PathRemainingMatchInfo {
        public final PathContainer pathMatched;
        public final PathContainer pathRemaining;
        public final PathMatchInfo pathMatchInfo;

        PathRemainingMatchInfo(PathContainer pathMatched, PathContainer pathRemaining) {
            this(pathMatched, pathRemaining, PathMatchInfo.EMPTY);
        }

        PathRemainingMatchInfo(PathContainer pathMatched, PathContainer pathRemaining, PathMatchInfo pathMatchInfo) {
            this.pathRemaining = pathRemaining;
            this.pathMatched = pathMatched;
            this.pathMatchInfo = pathMatchInfo;
        }

        public Map<String, String> getUriVariables() {
            return this.pathMatchInfo.getUriVariables();
        }

        public Map<String, MultiValueMap<String, String>> getMatrixVariables() {
            return this.pathMatchInfo.getMatrixVariables();
        }
    }
}

