/*
 * Decompiled with CFR 0.152.
 */
package infra.web.util.pattern;

import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.util.Collections;
import java.util.Map;

public class PathMatchInfo {
    public static final PathMatchInfo EMPTY = new PathMatchInfo(Collections.emptyMap(), Collections.emptyMap());
    private final Map<String, String> uriVariables;
    private final Map<String, MultiValueMap<String, String>> matrixVariables;

    public PathMatchInfo(Map<String, String> uriVars, @Nullable Map<String, MultiValueMap<String, String>> matrixVars) {
        this.uriVariables = Collections.unmodifiableMap(uriVars);
        this.matrixVariables = matrixVars != null ? Collections.unmodifiableMap(matrixVars) : Collections.emptyMap();
    }

    public Map<String, String> getUriVariables() {
        return this.uriVariables;
    }

    @Nullable
    public String getUriVariable(String name) {
        return this.uriVariables.get(name);
    }

    public Map<String, MultiValueMap<String, String>> getMatrixVariables() {
        return this.matrixVariables;
    }

    public MultiValueMap<String, String> getMatrixVariable(String name) {
        return this.matrixVariables.get(name);
    }

    public String toString() {
        return "PathMatchInfo[uriVariables=" + this.uriVariables + ", matrixVariables=" + this.matrixVariables + "]";
    }
}

