/*
 * Decompiled with CFR 0.152.
 */
package infra.web.util;

import infra.core.Conventions;
import infra.http.HttpHeaders;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.LoggerFactory;
import infra.session.WebSession;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.RequestContextDecorator;
import infra.web.multipart.Multipart;
import infra.web.util.UriComponents;
import infra.web.util.UriComponentsBuilder;
import infra.web.util.UriUtils;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public abstract class WebUtils {
    public static final String ERROR_MESSAGE_ATTRIBUTE = Conventions.getQualifiedAttributeName(WebUtils.class, (String)"error-message");
    public static final String ERROR_EXCEPTION_ATTRIBUTE = Conventions.getQualifiedAttributeName(WebUtils.class, (String)"error-exception");
    public static final String CONTENT_TYPE_CHARSET_PREFIX = ";charset=";
    public static final String SESSION_MUTEX_ATTRIBUTE = WebUtils.class.getName() + ".MUTEX";

    public static Object getSessionMutex(WebSession session) {
        Assert.notNull((Object)session, (String)"Session is required");
        Object mutex = session.getAttribute(SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }

    public static MultiValueMap<String, String> parseMatrixVariables(String matrixVariables) {
        LinkedMultiValueMap result = MultiValueMap.forLinkedHashMap();
        if (StringUtils.isBlank((String)matrixVariables)) {
            return result;
        }
        StringTokenizer pairs = new StringTokenizer(matrixVariables, ";");
        while (pairs.hasMoreTokens()) {
            String pair = pairs.nextToken();
            int index = pair.indexOf(61);
            if (index != -1) {
                String name = pair.substring(0, index);
                if (name.equalsIgnoreCase("jsessionid")) continue;
                String rawValue = pair.substring(index + 1);
                for (String value : StringUtils.commaDelimitedListToStringArray((String)rawValue)) {
                    result.add((Object)name, (Object)value);
                }
                continue;
            }
            result.add((Object)pair, (Object)"");
        }
        return result;
    }

    @Nullable
    public static <T> T getNativeContext(RequestContext request, @Nullable Class<T> requiredType) {
        if (requiredType != null) {
            if (requiredType.isInstance(request)) {
                return (T)request;
            }
            if (request instanceof RequestContextDecorator) {
                RequestContextDecorator wrapper = (RequestContextDecorator)request;
                return WebUtils.getNativeContext(wrapper.getDelegate(), requiredType);
            }
        }
        return null;
    }

    public static String getSanitizedPath(String path) {
        int index = path.indexOf("//");
        if (index >= 0) {
            StringBuilder sanitized = new StringBuilder(path);
            while (index != -1) {
                sanitized.deleteCharAt(index);
                index = sanitized.indexOf("//", index);
            }
            return sanitized.toString();
        }
        return path;
    }

    public static Map<String, String> decodePathVariables(Map<String, String> vars) {
        LinkedHashMap decodedVars = CollectionUtils.newLinkedHashMap((int)vars.size());
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            decodedVars.put(key, UriUtils.decode(value, StandardCharsets.UTF_8));
        }
        return decodedVars;
    }

    public static MultiValueMap<String, String> decodeMatrixVariables(MultiValueMap<String, String> vars) {
        LinkedMultiValueMap decodedVars = MultiValueMap.forLinkedHashMap((int)vars.size());
        for (Map.Entry entry : vars.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                decodedVars.add((Object)key, (Object)UriUtils.decode(value, StandardCharsets.UTF_8));
            }
        }
        return decodedVars;
    }

    public static String removeSemicolonContent(String lookupPath) {
        int semicolonIndex = lookupPath.indexOf(59);
        if (semicolonIndex == -1) {
            return lookupPath;
        }
        StringBuilder sb = new StringBuilder(lookupPath);
        while (semicolonIndex != -1) {
            int slashIndex = sb.indexOf("/", semicolonIndex + 1);
            if (slashIndex == -1) {
                return sb.substring(0, semicolonIndex);
            }
            sb.delete(semicolonIndex, slashIndex);
            semicolonIndex = sb.indexOf(";", semicolonIndex);
        }
        return sb.toString();
    }

    public static boolean isValidOrigin(RequestContext request, Collection<String> allowedOrigins) {
        Assert.notNull((Object)request, (String)"Request is required");
        Assert.notNull(allowedOrigins, (String)"Allowed origins is required");
        String origin = request.getHeaders().getOrigin();
        if (origin == null || allowedOrigins.contains("*")) {
            return true;
        }
        if (CollectionUtils.isEmpty(allowedOrigins)) {
            return WebUtils.isSameOrigin(request);
        }
        return allowedOrigins.contains(origin);
    }

    public static boolean isSameOrigin(RequestContext request) {
        HttpHeaders headers = request.getHeaders();
        String origin = headers.getOrigin();
        if (origin == null) {
            return true;
        }
        String scheme = request.getScheme();
        String host = request.getServerName();
        int port = request.getServerPort();
        UriComponents originUrl = UriComponentsBuilder.fromOriginHeader(origin).build();
        return Objects.equals(scheme, originUrl.getScheme()) && Objects.equals(host, originUrl.getHost()) && WebUtils.getPort(scheme, port) == WebUtils.getPort(originUrl.getScheme(), originUrl.getPort());
    }

    private static int getPort(@Nullable String scheme, int port) {
        if (port == -1) {
            if ("http".equals(scheme) || "ws".equals(scheme)) {
                port = 80;
            } else if ("https".equals(scheme) || "wss".equals(scheme)) {
                port = 443;
            }
        }
        return port;
    }

    public static void cleanupMultipartRequest(@Nullable MultiValueMap<String, Multipart> multipartFiles) {
        if (CollectionUtils.isNotEmpty(multipartFiles)) {
            for (Map.Entry entry : multipartFiles.entrySet()) {
                List value = (List)entry.getValue();
                for (Multipart multipartFile : value) {
                    try {
                        multipartFile.cleanup();
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(WebUtils.class).error("error occurred when cleanup multipart", (Throwable)e);
                    }
                }
            }
        }
    }
}

