/*
 * Decompiled with CFR 0.152.
 */
package infra.web.util;

import infra.lang.Assert;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.ExceptionUtils;
import java.util.Locale;
import java.util.Set;

public class DisconnectedClientHelper {
    private static final Set<String> EXCEPTION_PHRASES = Set.of("broken pipe", "connection reset");
    private static final Set<String> EXCEPTION_TYPE_NAMES = Set.of("AbortedException", "ClientAbortException", "EOFException", "EofException");
    private final Logger logger;

    public DisconnectedClientHelper(String logCategory) {
        Assert.notNull((Object)logCategory, (String)"'logCategory' is required");
        this.logger = LoggerFactory.getLogger((String)logCategory);
    }

    public boolean checkAndLogClientDisconnectedException(Throwable ex) {
        if (DisconnectedClientHelper.isClientDisconnectedException(ex)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Looks like the client has gone away", ex);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Looks like the client has gone away: {} (For a full stack trace, set the log category '{}' to TRACE level.)", (Object)ex, (Object)this.logger);
            }
            return true;
        }
        return false;
    }

    public static boolean isClientDisconnectedException(Throwable ex) {
        String message = ExceptionUtils.getMostSpecificCause((Throwable)ex).getMessage();
        if (message != null) {
            String text = message.toLowerCase(Locale.ROOT);
            for (String phrase : EXCEPTION_PHRASES) {
                if (!text.contains(phrase)) continue;
                return true;
            }
        }
        return EXCEPTION_TYPE_NAMES.contains(ex.getClass().getSimpleName());
    }
}

