/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.invoker;

import infra.core.MethodParameter;
import infra.core.ParameterizedTypeReference;
import infra.core.ReactiveAdapter;
import infra.core.ReactiveAdapterRegistry;
import infra.core.ReactiveStreams;
import infra.core.io.Resource;
import infra.http.DefaultHttpHeaders;
import infra.http.HttpEntity;
import infra.http.HttpHeaders;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.annotation.RequestPart;
import infra.web.multipart.MultipartFile;
import infra.web.service.invoker.AbstractNamedValueArgumentResolver;
import infra.web.service.invoker.HttpExchangeAdapter;
import infra.web.service.invoker.HttpRequestValues;
import infra.web.service.invoker.ReactiveHttpRequestValues;
import infra.web.service.invoker.ReactorHttpExchangeAdapter;
import java.lang.reflect.Type;

public class RequestPartArgumentResolver
extends AbstractNamedValueArgumentResolver {
    @Nullable
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public RequestPartArgumentResolver(HttpExchangeAdapter exchangeAdapter) {
        if (ReactiveStreams.reactorPresent) {
            ReactiveAdapterRegistry reactiveAdapterRegistry;
            if (exchangeAdapter instanceof ReactorHttpExchangeAdapter) {
                ReactorHttpExchangeAdapter reactorAdapter = (ReactorHttpExchangeAdapter)exchangeAdapter;
                reactiveAdapterRegistry = reactorAdapter.getReactiveAdapterRegistry();
            } else {
                reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
            }
            this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        } else {
            this.reactiveAdapterRegistry = null;
        }
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        String label;
        RequestPart annot = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        boolean isMultiPartFile = parameter.getParameterType().equals(MultipartFile.class);
        String string = label = isMultiPartFile ? "MultipartFile" : "request part";
        if (annot != null) {
            return new AbstractNamedValueArgumentResolver.NamedValueInfo(annot.name(), annot.required(), null, label, true);
        }
        if (isMultiPartFile) {
            return new AbstractNamedValueArgumentResolver.NamedValueInfo("", true, null, label, true);
        }
        return null;
    }

    @Override
    protected void addRequestValue(String name, Object value, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        Class type;
        ReactiveAdapter adapter;
        if (this.reactiveAdapterRegistry != null && (adapter = this.reactiveAdapterRegistry.getAdapter(type = parameter.getParameterType())) != null) {
            MethodParameter nestedParameter = parameter.nested();
            String message = "Async type for @RequestPart should produce value(s)";
            Assert.isTrue((!adapter.isNoValue() ? 1 : 0) != 0, (String)message);
            Assert.isTrue((nestedParameter.getNestedParameterType() != Void.class ? 1 : 0) != 0, (String)message);
            if (!(requestValues instanceof ReactiveHttpRequestValues.Builder)) {
                throw new IllegalStateException("RequestPart with a reactive type is only supported with reactive client");
            }
            ReactiveHttpRequestValues.Builder reactiveValues = (ReactiveHttpRequestValues.Builder)requestValues;
            reactiveValues.addRequestPartPublisher(name, adapter.toPublisher(value), RequestPartArgumentResolver.asParameterizedTypeRef(nestedParameter));
            return;
        }
        if (value instanceof MultipartFile) {
            MultipartFile multipartFile = (MultipartFile)value;
            value = RequestPartArgumentResolver.toHttpEntity(name, multipartFile);
        }
        requestValues.addRequestPart(name, value);
    }

    private static ParameterizedTypeReference<Object> asParameterizedTypeRef(MethodParameter nestedParam) {
        return ParameterizedTypeReference.forType((Type)nestedParam.getNestedGenericParameterType());
    }

    private static Object toHttpEntity(String name, MultipartFile multipartFile) {
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        if (multipartFile.getOriginalFilename() != null) {
            headers.setContentDispositionFormData(name, multipartFile.getOriginalFilename());
        }
        if (multipartFile.getContentType() != null) {
            ((HttpHeaders)headers).add("Content-Type", multipartFile.getContentType());
        }
        return new HttpEntity<Resource>(multipartFile.getResource(), headers);
    }
}

