/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.invoker;

import infra.core.MethodParameter;
import infra.core.ParameterizedTypeReference;
import infra.core.ReactiveAdapter;
import infra.core.ReactiveAdapterRegistry;
import infra.core.ReactiveStreams;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.annotation.RequestBody;
import infra.web.service.invoker.HttpExchangeAdapter;
import infra.web.service.invoker.HttpRequestValues;
import infra.web.service.invoker.HttpServiceArgumentResolver;
import infra.web.service.invoker.ReactiveHttpRequestValues;
import infra.web.service.invoker.ReactorHttpExchangeAdapter;
import java.lang.reflect.Type;

public class RequestBodyArgumentResolver
implements HttpServiceArgumentResolver {
    @Nullable
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public RequestBodyArgumentResolver(HttpExchangeAdapter exchangeAdapter) {
        if (ReactiveStreams.reactorPresent) {
            ReactiveAdapterRegistry reactiveAdapterRegistry;
            if (exchangeAdapter instanceof ReactorHttpExchangeAdapter) {
                ReactorHttpExchangeAdapter reactorAdapter = (ReactorHttpExchangeAdapter)exchangeAdapter;
                reactiveAdapterRegistry = reactorAdapter.getReactiveAdapterRegistry();
            } else {
                reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
            }
            this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        } else {
            this.reactiveAdapterRegistry = null;
        }
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        RequestBody annot = (RequestBody)parameter.getParameterAnnotation(RequestBody.class);
        if (annot == null) {
            return false;
        }
        if (argument != null) {
            ReactiveAdapter adapter;
            if (this.reactiveAdapterRegistry != null && (adapter = this.reactiveAdapterRegistry.getAdapter(parameter.getParameterType())) != null) {
                MethodParameter nestedParameter = parameter.nested();
                String message = "Async type for @RequestBody should produce value(s)";
                Assert.isTrue((!adapter.isNoValue() ? 1 : 0) != 0, (String)message);
                Assert.isTrue((nestedParameter.getNestedParameterType() != Void.class ? 1 : 0) != 0, (String)message);
                if (!(requestValues instanceof ReactiveHttpRequestValues.Builder)) {
                    throw new IllegalStateException("RequestBody with a reactive type is only supported with reactive client");
                }
                ReactiveHttpRequestValues.Builder reactiveRequestValues = (ReactiveHttpRequestValues.Builder)requestValues;
                reactiveRequestValues.setBodyPublisher(adapter.toPublisher(argument), RequestBodyArgumentResolver.asParameterizedTypeRef(nestedParameter));
                return true;
            }
            requestValues.setBodyValue(argument);
        }
        return true;
    }

    private static ParameterizedTypeReference<Object> asParameterizedTypeRef(MethodParameter nestedParam) {
        return ParameterizedTypeReference.forType((Type)nestedParam.getNestedGenericParameterType());
    }
}

