/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.invoker;

import infra.core.ParameterizedTypeReference;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.MediaType;
import infra.http.client.MultipartBodyBuilder;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.web.service.invoker.HttpRequestValues;
import infra.web.util.UriBuilderFactory;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class ReactiveHttpRequestValues
extends HttpRequestValues {
    @Nullable
    private final Publisher<?> body;
    @Nullable
    private final ParameterizedTypeReference<?> bodyElementType;

    private ReactiveHttpRequestValues(@Nullable HttpMethod httpMethod, @Nullable URI uri, @Nullable UriBuilderFactory uriBuilderFactory, @Nullable String uriTemplate, Map<String, String> uriVars, HttpHeaders headers, MultiValueMap<String, String> cookies, Map<String, Object> attributes, @Nullable Object bodyValue, @Nullable Publisher<?> body, @Nullable ParameterizedTypeReference<?> elementType) {
        super(httpMethod, uri, uriBuilderFactory, uriTemplate, uriVars, headers, cookies, attributes, bodyValue);
        this.body = body;
        this.bodyElementType = elementType;
    }

    @Nullable
    public Publisher<?> getBodyPublisher() {
        return this.body;
    }

    @Nullable
    public ParameterizedTypeReference<?> getBodyPublisherElementType() {
        return this.bodyElementType;
    }

    @Nullable
    public Publisher<?> getBody() {
        return this.getBodyPublisher();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends HttpRequestValues.Builder {
        @Nullable
        private MultipartBodyBuilder multipartBuilder;
        @Nullable
        private Publisher<?> body;
        @Nullable
        private ParameterizedTypeReference<?> bodyElementType;

        @Override
        public Builder setHttpMethod(HttpMethod httpMethod) {
            super.setHttpMethod(httpMethod);
            return this;
        }

        @Override
        public Builder setUri(URI uri) {
            super.setUri(uri);
            return this;
        }

        @Override
        public Builder setUriBuilderFactory(@Nullable UriBuilderFactory uriBuilderFactory) {
            super.setUriBuilderFactory(uriBuilderFactory);
            return this;
        }

        @Override
        public Builder setUriTemplate(String uriTemplate) {
            super.setUriTemplate(uriTemplate);
            return this;
        }

        @Override
        public Builder setUriVariable(String name, String value) {
            super.setUriVariable(name, value);
            return this;
        }

        @Override
        public Builder setAccept(List<MediaType> acceptableMediaTypes) {
            super.setAccept(acceptableMediaTypes);
            return this;
        }

        @Override
        public Builder setContentType(MediaType contentType) {
            super.setContentType(contentType);
            return this;
        }

        @Override
        public Builder addHeader(String headerName, String ... headerValues) {
            super.addHeader(headerName, headerValues);
            return this;
        }

        @Override
        public Builder addCookie(String name, String ... values) {
            super.addCookie(name, values);
            return this;
        }

        @Override
        public Builder addRequestParameter(String name, String ... values) {
            super.addRequestParameter(name, values);
            return this;
        }

        @Override
        public Builder addAttribute(String name, Object value) {
            super.addAttribute(name, value);
            return this;
        }

        @Override
        public Builder addRequestPart(String name, Object part) {
            this.multipartBuilder = this.multipartBuilder != null ? this.multipartBuilder : new MultipartBodyBuilder();
            this.multipartBuilder.part(name, part);
            return this;
        }

        public <T, P extends Publisher<T>> Builder addRequestPartPublisher(String name, P publisher, ParameterizedTypeReference<T> elementTye) {
            this.multipartBuilder = this.multipartBuilder != null ? this.multipartBuilder : new MultipartBodyBuilder();
            this.multipartBuilder.asyncPart(name, publisher, elementTye);
            return this;
        }

        @Override
        public void setBodyValue(Object bodyValue) {
            super.setBodyValue(bodyValue);
            this.body = null;
            this.bodyElementType = null;
        }

        public <T, P extends Publisher<T>> void setBodyPublisher(P body, ParameterizedTypeReference<T> elementTye) {
            this.body = body;
            this.bodyElementType = elementTye;
            super.setBodyValue(null);
        }

        public <T, P extends Publisher<T>> void setBody(P body, ParameterizedTypeReference<T> elementTye) {
            this.setBodyPublisher(body, elementTye);
        }

        @Override
        public ReactiveHttpRequestValues build() {
            return (ReactiveHttpRequestValues)super.build();
        }

        @Override
        protected boolean hasParts() {
            return this.multipartBuilder != null;
        }

        @Override
        protected boolean hasBody() {
            return super.hasBody() || this.body != null;
        }

        @Override
        protected Object buildMultipartBody() {
            Assert.notNull((Object)this.multipartBuilder, (String)"`multipartBuilder` is null, was hasParts() not called?");
            return this.multipartBuilder.build();
        }

        @Override
        protected ReactiveHttpRequestValues createRequestValues(@Nullable HttpMethod httpMethod, @Nullable URI uri, @Nullable UriBuilderFactory uriBuilderFactory, @Nullable String uriTemplate, Map<String, String> uriVars, HttpHeaders headers, MultiValueMap<String, String> cookies, Map<String, Object> attributes, @Nullable Object bodyValue) {
            return new ReactiveHttpRequestValues(httpMethod, uri, uriBuilderFactory, uriTemplate, uriVars, headers, cookies, attributes, bodyValue, this.body, this.bodyElementType);
        }
    }
}

