/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.invoker;

import infra.aop.ProxyMethodInvocation;
import infra.aop.framework.ProxyFactory;
import infra.core.MethodIntrospector;
import infra.core.ReactiveAdapterRegistry;
import infra.core.StringValueResolver;
import infra.core.annotation.AnnotatedElementUtils;
import infra.core.conversion.ConversionService;
import infra.format.support.DefaultFormattingConversionService;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.service.annotation.HttpExchange;
import infra.web.service.invoker.AbstractReactorHttpExchangeAdapter;
import infra.web.service.invoker.CookieValueArgumentResolver;
import infra.web.service.invoker.HttpExchangeAdapter;
import infra.web.service.invoker.HttpMethodArgumentResolver;
import infra.web.service.invoker.HttpServiceArgumentResolver;
import infra.web.service.invoker.HttpServiceMethod;
import infra.web.service.invoker.PathVariableArgumentResolver;
import infra.web.service.invoker.RequestAttributeArgumentResolver;
import infra.web.service.invoker.RequestBodyArgumentResolver;
import infra.web.service.invoker.RequestHeaderArgumentResolver;
import infra.web.service.invoker.RequestParamArgumentResolver;
import infra.web.service.invoker.RequestPartArgumentResolver;
import infra.web.service.invoker.UriBuilderFactoryArgumentResolver;
import infra.web.service.invoker.UrlArgumentResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public final class HttpServiceProxyFactory {
    private final HttpExchangeAdapter exchangeAdapter;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    @Nullable
    private final StringValueResolver embeddedValueResolver;

    private HttpServiceProxyFactory(HttpExchangeAdapter exchangeAdapter, List<HttpServiceArgumentResolver> argumentResolvers, @Nullable StringValueResolver embeddedValueResolver) {
        this.exchangeAdapter = exchangeAdapter;
        this.argumentResolvers = argumentResolvers;
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<HttpServiceMethod> httpServiceMethods = MethodIntrospector.filterMethods(serviceType, this::isExchangeMethod).stream().map(method -> this.createHttpServiceMethod(serviceType, (Method)method)).toList();
        return (S)ProxyFactory.getProxy(serviceType, (Interceptor)new HttpServiceMethodInterceptor(httpServiceMethods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, HttpExchange.class);
    }

    private <S> HttpServiceMethod createHttpServiceMethod(Class<S> serviceType, Method method) {
        Assert.notNull(this.argumentResolvers, (String)"No argument resolvers: afterPropertiesSet was not called");
        return new HttpServiceMethod(method, serviceType, this.argumentResolvers, this.exchangeAdapter, this.embeddedValueResolver);
    }

    public static Builder forAdapter(HttpExchangeAdapter exchangeAdapter) {
        return new Builder().exchangeAdapter(exchangeAdapter);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class HttpServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, HttpServiceMethod> httpServiceMethods;

        private HttpServiceMethodInterceptor(List<HttpServiceMethod> methods) {
            this.httpServiceMethods = methods.stream().collect(Collectors.toMap(HttpServiceMethod::getMethod, Function.identity()));
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            HttpServiceMethod httpServiceMethod = this.httpServiceMethods.get(method);
            if (httpServiceMethod != null) {
                return httpServiceMethod.invoke(invocation.getArguments());
            }
            if (method.isDefault() && invocation instanceof ProxyMethodInvocation) {
                ProxyMethodInvocation inv = (ProxyMethodInvocation)invocation;
                Object proxy = inv.getProxy();
                return InvocationHandler.invokeDefault(proxy, method, invocation.getArguments());
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }
    }

    public static final class Builder {
        @Nullable
        private HttpExchangeAdapter exchangeAdapter;
        private final List<HttpServiceArgumentResolver> customArgumentResolvers = new ArrayList<HttpServiceArgumentResolver>();
        @Nullable
        private ConversionService conversionService;
        @Nullable
        private StringValueResolver embeddedValueResolver;

        public Builder exchangeAdapter(HttpExchangeAdapter adapter) {
            this.exchangeAdapter = adapter;
            return this;
        }

        public Builder customArgumentResolver(HttpServiceArgumentResolver resolver) {
            this.customArgumentResolvers.add(resolver);
            return this;
        }

        public Builder conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder embeddedValueResolver(StringValueResolver embeddedValueResolver) {
            this.embeddedValueResolver = embeddedValueResolver;
            return this;
        }

        public Builder reactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
            HttpExchangeAdapter httpExchangeAdapter = this.exchangeAdapter;
            if (httpExchangeAdapter instanceof AbstractReactorHttpExchangeAdapter) {
                AbstractReactorHttpExchangeAdapter settable = (AbstractReactorHttpExchangeAdapter)httpExchangeAdapter;
                settable.setReactiveAdapterRegistry(registry);
            }
            return this;
        }

        public Builder blockTimeout(@Nullable Duration blockTimeout) {
            HttpExchangeAdapter httpExchangeAdapter = this.exchangeAdapter;
            if (httpExchangeAdapter instanceof AbstractReactorHttpExchangeAdapter) {
                AbstractReactorHttpExchangeAdapter settable = (AbstractReactorHttpExchangeAdapter)httpExchangeAdapter;
                settable.setBlockTimeout(blockTimeout);
            }
            return this;
        }

        public HttpServiceProxyFactory build() {
            Assert.notNull((Object)this.exchangeAdapter, (String)"HttpClientAdapter is required");
            return new HttpServiceProxyFactory(this.exchangeAdapter, this.initArgumentResolvers(), this.embeddedValueResolver);
        }

        public <S> S createClient(Class<S> serviceType) {
            return this.build().createClient(serviceType);
        }

        private List<HttpServiceArgumentResolver> initArgumentResolvers() {
            ArrayList<HttpServiceArgumentResolver> resolvers = new ArrayList<HttpServiceArgumentResolver>(this.customArgumentResolvers);
            ConversionService service = this.conversionService != null ? this.conversionService : new DefaultFormattingConversionService();
            resolvers.add(new RequestHeaderArgumentResolver(service));
            resolvers.add(new RequestBodyArgumentResolver(this.exchangeAdapter));
            resolvers.add(new PathVariableArgumentResolver(service));
            resolvers.add(new RequestParamArgumentResolver(service));
            resolvers.add(new RequestPartArgumentResolver(this.exchangeAdapter));
            resolvers.add(new CookieValueArgumentResolver(service));
            if (this.exchangeAdapter.supportsRequestAttributes()) {
                resolvers.add(new RequestAttributeArgumentResolver());
            }
            resolvers.add(new UrlArgumentResolver());
            resolvers.add(new UriBuilderFactoryArgumentResolver());
            resolvers.add(new HttpMethodArgumentResolver());
            return resolvers;
        }
    }
}

