/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.invoker;

import infra.core.MethodParameter;
import infra.core.ParameterNameDiscoverer;
import infra.core.ParameterizedTypeReference;
import infra.core.ReactiveAdapter;
import infra.core.ReactiveAdapterRegistry;
import infra.core.ReactiveStreams;
import infra.core.StringValueResolver;
import infra.core.annotation.MergedAnnotation;
import infra.core.annotation.MergedAnnotationPredicates;
import infra.core.annotation.MergedAnnotations;
import infra.core.annotation.RepeatableContainers;
import infra.core.annotation.SynthesizingMethodParameter;
import infra.http.HttpHeaders;
import infra.http.HttpMessage;
import infra.http.HttpMethod;
import infra.http.MediaType;
import infra.http.ResponseEntity;
import infra.http.client.ClientHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.client.ClientResponse;
import infra.web.service.annotation.HttpExchange;
import infra.web.service.invoker.HttpExchangeAdapter;
import infra.web.service.invoker.HttpRequestValues;
import infra.web.service.invoker.HttpServiceArgumentResolver;
import infra.web.service.invoker.ReactiveHttpRequestValues;
import infra.web.service.invoker.ReactorHttpExchangeAdapter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

final class HttpServiceMethod {
    private final Method method;
    private final MethodParameter[] parameters;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    private final HttpRequestValuesInitializer requestValuesInitializer;
    private final ResponseFunction responseFunction;

    HttpServiceMethod(Method method, Class<?> containingClass, List<HttpServiceArgumentResolver> argumentResolvers, HttpExchangeAdapter adapter, @Nullable StringValueResolver embeddedValueResolver) {
        this.method = method;
        this.parameters = HttpServiceMethod.initMethodParameters(method);
        this.argumentResolvers = argumentResolvers;
        boolean isReactorAdapter = ReactiveStreams.reactorPresent && adapter instanceof ReactorHttpExchangeAdapter;
        this.requestValuesInitializer = HttpRequestValuesInitializer.create(method, containingClass, embeddedValueResolver, isReactorAdapter ? ReactiveHttpRequestValues::builder : HttpRequestValues::builder);
        ResponseFunction responseFunction = null;
        if (isReactorAdapter) {
            responseFunction = ReactorExchangeResponseFunction.create((ReactorHttpExchangeAdapter)adapter, method);
        }
        if (responseFunction == null) {
            responseFunction = HttpServiceMethod.createResponseFunction(adapter, method);
        }
        this.responseFunction = responseFunction;
    }

    private static MethodParameter[] initMethodParameters(Method method) {
        int count = method.getParameterCount();
        if (count == 0) {
            return new MethodParameter[0];
        }
        ParameterNameDiscoverer nameDiscoverer = ParameterNameDiscoverer.getSharedInstance();
        MethodParameter[] parameters = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            parameters[i] = new SynthesizingMethodParameter(method, i);
            parameters[i].initParameterNameDiscovery(nameDiscoverer);
        }
        return parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    @Nullable
    public Object invoke(Object[] arguments) {
        HttpRequestValues.Builder requestValues = this.requestValuesInitializer.initializeRequestValuesBuilder();
        this.applyArguments(requestValues, arguments);
        return this.responseFunction.execute(requestValues.build());
    }

    private void applyArguments(HttpRequestValues.Builder requestValues, Object[] arguments) {
        MethodParameter[] parameters = this.parameters;
        Assert.isTrue((arguments.length == parameters.length ? 1 : 0) != 0, (String)"Method argument mismatch");
        for (int i = 0; i < arguments.length; ++i) {
            Object value = arguments[i];
            boolean resolved = false;
            for (HttpServiceArgumentResolver resolver : this.argumentResolvers) {
                if (!resolver.resolve(value, parameters[i], requestValues)) continue;
                resolved = true;
                break;
            }
            if (resolved) continue;
            throw new IllegalStateException("Could not resolve parameter [%d] in %s: No suitable resolver".formatted(this.parameters[i].getParameterIndex(), this.parameters[i].getExecutable().toGenericString()));
        }
    }

    private static ResponseFunction createResponseFunction(HttpExchangeAdapter client, Method method) {
        Class paramType;
        Class returnType;
        MethodParameter param;
        block12: {
            block11: {
                param = HttpServiceMethod.returnType(method);
                returnType = param.getParameterType();
                if (HttpServiceMethod.isAsync(returnType)) {
                    ResponseFunction function = HttpServiceMethod.createResponseFunctionAsync(client, param);
                    if (CompletionStage.class.isAssignableFrom(returnType)) {
                        return request -> {
                            infra.util.concurrent.Future result = (infra.util.concurrent.Future)function.execute(request);
                            return result.completable();
                        };
                    }
                    return function;
                }
                paramType = param.getNestedParameterType();
                if (ClassUtils.isVoidType((Class)paramType)) {
                    return request -> {
                        client.exchange(request).close();
                        return null;
                    };
                }
                if (paramType == ClientHttpResponse.class) break block11;
                if (paramType != ClientResponse.class) break block12;
            }
            return client::exchange;
        }
        if (paramType == HttpHeaders.class) {
            return request -> {
                try (ClientResponse response = client.exchange(request);){
                    Object object = HttpServiceMethod.asOptionalIfNecessary(response.getHeaders(), param);
                    return object;
                }
            };
        }
        if (paramType == ResponseEntity.class) {
            MethodParameter bodyParam = param.nested();
            if (bodyParam.getNestedParameterType().equals(Void.class)) {
                return request -> HttpServiceMethod.asOptionalIfNecessary(client.exchangeForBodilessEntity(request), param);
            }
            ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType((Type)bodyParam.getNestedGenericParameterType());
            return request -> HttpServiceMethod.asOptionalIfNecessary(client.exchangeForEntity(request, bodyTypeRef), param);
        }
        ReactiveAdapterRegistry sharedRegistry = ReactiveAdapterRegistry.getSharedInstance();
        ReactiveAdapter returnAdapter = sharedRegistry.getAdapter(returnType);
        if (returnAdapter != null) {
            ReactiveAdapter reactiveAdapter = sharedRegistry.getAdapter(infra.util.concurrent.Future.class);
            if (reactiveAdapter == null) {
                throw new IllegalStateException("Return type: '%s' reactive adapter not found".formatted(infra.util.concurrent.Future.class.getName()));
            }
            ResponseFunction responseFunction = HttpServiceMethod.createResponseFunctionAsync(client, param.nested());
            return request -> returnAdapter.fromPublisher(reactiveAdapter.toPublisher(responseFunction.execute(request)));
        }
        ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType((Type)param.getNestedGenericParameterType());
        return request -> HttpServiceMethod.asOptionalIfNecessary(client.exchangeForBody(request, bodyTypeRef), param);
    }

    private static boolean isAsync(Class<?> parameterType) {
        return Future.class == parameterType || infra.util.concurrent.Future.class == parameterType || CompletionStage.class == parameterType || CompletableFuture.class == parameterType;
    }

    private static ResponseFunction createResponseFunctionAsync(HttpExchangeAdapter client, MethodParameter param) {
        Class paramType;
        block8: {
            block7: {
                paramType = param.getNestedParameterType();
                if (ClassUtils.isVoidType((Class)paramType)) {
                    return request -> client.exchangeAsync(request).onSuccess(ClientHttpResponse::close);
                }
                if (paramType == ClientHttpResponse.class) break block7;
                if (paramType != ClientResponse.class) break block8;
            }
            return client::exchangeAsync;
        }
        if (paramType == HttpHeaders.class) {
            return request -> client.exchangeAsync(request).onSuccess(ClientHttpResponse::close).map(HttpMessage::getHeaders);
        }
        if (paramType == ResponseEntity.class) {
            MethodParameter bodyParam = param.nested();
            if (bodyParam.getNestedParameterType().equals(Void.class)) {
                return client::exchangeForBodilessEntityAsync;
            }
            ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType((Type)bodyParam.getNestedGenericParameterType());
            return request -> client.exchangeForEntityAsync(request, bodyTypeRef);
        }
        ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType((Type)param.getNestedGenericParameterType());
        return request -> client.exchangeAsync(request).map(response -> response.bodyTo(bodyTypeRef));
    }

    private static MethodParameter returnType(Method method) {
        MethodParameter param = new MethodParameter(method, -1).nestedIfOptional();
        if (HttpServiceMethod.isAsync(param.getParameterType())) {
            param = param.nested();
        }
        return param;
    }

    @Nullable
    private static Object asOptionalIfNecessary(@Nullable Object response, MethodParameter param) {
        return param.getParameterType() == Optional.class ? Optional.ofNullable(response) : response;
    }

    private record HttpRequestValuesInitializer(@Nullable HttpMethod httpMethod, @Nullable String url, @Nullable MediaType contentType, @Nullable List<MediaType> acceptMediaTypes, @Nullable MultiValueMap<String, String> otherHeaders, Supplier<HttpRequestValues.Builder> requestValuesSupplier) {
        public HttpRequestValues.Builder initializeRequestValuesBuilder() {
            HttpRequestValues.Builder requestValues = this.requestValuesSupplier.get();
            if (this.httpMethod != null) {
                requestValues.setHttpMethod(this.httpMethod);
            }
            if (this.url != null) {
                requestValues.setUriTemplate(this.url);
            }
            if (this.contentType != null) {
                requestValues.setContentType(this.contentType);
            }
            if (this.acceptMediaTypes != null) {
                requestValues.setAccept(this.acceptMediaTypes);
            }
            if (this.otherHeaders != null) {
                this.otherHeaders.forEach((name, values) -> {
                    if (values.size() == 1) {
                        requestValues.addHeader((String)name, (String)values.get(0));
                    } else {
                        requestValues.addHeader((String)name, values.toArray(new String[0]));
                    }
                });
            }
            return requestValues;
        }

        public static HttpRequestValuesInitializer create(Method method, Class<?> containingClass, @Nullable StringValueResolver embeddedValueResolver, Supplier<HttpRequestValues.Builder> requestValuesSupplier) {
            List<AnnotationDescriptor> methodHttpExchanges = HttpRequestValuesInitializer.getAnnotationDescriptors(method);
            Assert.state((!methodHttpExchanges.isEmpty() ? 1 : 0) != 0, () -> "Expected @HttpExchange annotation on method " + method);
            Assert.state((methodHttpExchanges.size() == 1 ? 1 : 0) != 0, () -> "Multiple @HttpExchange annotations found on method %s, but only one is allowed: %s".formatted(method, methodHttpExchanges));
            List<AnnotationDescriptor> typeHttpExchanges = HttpRequestValuesInitializer.getAnnotationDescriptors(containingClass);
            Assert.state((typeHttpExchanges.size() <= 1 ? 1 : 0) != 0, () -> "Multiple @HttpExchange annotations found on %s, but only one is allowed: %s".formatted(containingClass, typeHttpExchanges));
            HttpExchange methodAnnotation = methodHttpExchanges.get((int)0).httpExchange;
            HttpExchange typeAnnotation = !typeHttpExchanges.isEmpty() ? typeHttpExchanges.get((int)0).httpExchange : null;
            Assert.notNull((Object)methodAnnotation, (String)"Expected HttpRequest annotation");
            HttpMethod httpMethod = HttpRequestValuesInitializer.initHttpMethod(typeAnnotation, methodAnnotation);
            String url = HttpRequestValuesInitializer.initUrl(typeAnnotation, methodAnnotation, embeddedValueResolver);
            MediaType contentType = HttpRequestValuesInitializer.initContentType(typeAnnotation, methodAnnotation);
            List<MediaType> acceptableMediaTypes = HttpRequestValuesInitializer.initAccept(typeAnnotation, methodAnnotation);
            MultiValueMap<String, String> headers = HttpRequestValuesInitializer.initHeaders(typeAnnotation, methodAnnotation, embeddedValueResolver);
            return new HttpRequestValuesInitializer(httpMethod, url, contentType, acceptableMediaTypes, headers, requestValuesSupplier);
        }

        @Nullable
        private static HttpMethod initHttpMethod(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            String value1 = typeAnnot != null ? typeAnnot.method() : null;
            String value2 = annot.method();
            if (StringUtils.hasText((String)value2)) {
                return HttpMethod.valueOf(value2);
            }
            if (StringUtils.hasText((String)value1)) {
                return HttpMethod.valueOf(value1);
            }
            return null;
        }

        @Nullable
        private static String initUrl(@Nullable HttpExchange typeAnnot, HttpExchange annot, @Nullable StringValueResolver embeddedValueResolver) {
            String url1 = typeAnnot != null ? typeAnnot.url() : null;
            String url2 = annot.url();
            if (embeddedValueResolver != null) {
                url1 = url1 != null ? embeddedValueResolver.resolveStringValue(url1) : null;
                url2 = embeddedValueResolver.resolveStringValue(url2);
            }
            boolean hasUrl1 = StringUtils.hasText((String)url1);
            boolean hasUrl2 = StringUtils.hasText((String)url2);
            if (hasUrl1 && hasUrl2) {
                return url1 + (!url1.endsWith("/") && !url2.startsWith("/") ? "/" : "") + url2;
            }
            if (!hasUrl1 && !hasUrl2) {
                return null;
            }
            return hasUrl2 ? url2 : url1;
        }

        @Nullable
        private static MediaType initContentType(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            String value1 = typeAnnot != null ? typeAnnot.contentType() : null;
            String value2 = annot.contentType();
            if (StringUtils.hasText((String)value2)) {
                return MediaType.parseMediaType(value2);
            }
            if (StringUtils.hasText((String)value1)) {
                return MediaType.parseMediaType(value1);
            }
            return null;
        }

        @Nullable
        private static List<MediaType> initAccept(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            Object[] value1 = typeAnnot != null ? typeAnnot.accept() : null;
            Object[] value2 = annot.accept();
            if (ObjectUtils.isNotEmpty((Object[])value2)) {
                return MediaType.parseMediaTypes(Arrays.asList(value2));
            }
            if (ObjectUtils.isNotEmpty((Object[])value1)) {
                return MediaType.parseMediaTypes(Arrays.asList(value1));
            }
            return null;
        }

        @Nullable
        private static MultiValueMap<String, String> initHeaders(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation, @Nullable StringValueResolver embeddedValueResolver) {
            MultiValueMap<String, String> typeLevelHeaders;
            MultiValueMap<String, String> methodLevelHeaders = HttpRequestValuesInitializer.parseHeaders(methodAnnotation.headers(), embeddedValueResolver);
            if (!ObjectUtils.isEmpty(methodLevelHeaders)) {
                return methodLevelHeaders;
            }
            MultiValueMap<String, String> multiValueMap = typeLevelHeaders = typeAnnotation != null ? HttpRequestValuesInitializer.parseHeaders(typeAnnotation.headers(), embeddedValueResolver) : null;
            if (!ObjectUtils.isEmpty(typeLevelHeaders)) {
                return typeLevelHeaders;
            }
            return null;
        }

        private static MultiValueMap<String, String> parseHeaders(String[] headersArray, @Nullable StringValueResolver embeddedValueResolver) {
            LinkedMultiValueMap headers = new LinkedMultiValueMap();
            for (String h : headersArray) {
                String[] headerPair = StringUtils.split((String)h, (String)"=");
                if (headerPair == null) continue;
                String headerName = headerPair[0].trim();
                ArrayList<String> headerValues = new ArrayList<String>();
                Set parsedValues = StringUtils.commaDelimitedListToSet((String)headerPair[1]);
                for (String headerValue : parsedValues) {
                    if (embeddedValueResolver != null) {
                        headerValue = embeddedValueResolver.resolveStringValue(headerValue);
                    }
                    if (headerValue == null) continue;
                    headerValue = headerValue.trim();
                    headerValues.add(headerValue);
                }
                if (headerValues.isEmpty()) continue;
                headers.addAll((Object)headerName, headerValues);
            }
            return headers;
        }

        private static List<AnnotationDescriptor> getAnnotationDescriptors(AnnotatedElement element) {
            return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.none()).stream(HttpExchange.class).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).map(AnnotationDescriptor::new).distinct().toList();
        }

        private static class AnnotationDescriptor {
            private final HttpExchange httpExchange;
            private final MergedAnnotation<?> root;

            AnnotationDescriptor(MergedAnnotation<HttpExchange> mergedAnnotation) {
                this.httpExchange = (HttpExchange)mergedAnnotation.synthesize();
                this.root = mergedAnnotation.getRoot();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object obj) {
                if (!(obj instanceof AnnotationDescriptor)) return false;
                AnnotationDescriptor that = (AnnotationDescriptor)obj;
                if (!this.httpExchange.equals(that.httpExchange)) return false;
                return true;
            }

            public int hashCode() {
                return this.httpExchange.hashCode();
            }

            public String toString() {
                return this.root.synthesize().toString();
            }
        }
    }

    private record ReactorExchangeResponseFunction(Function<HttpRequestValues, Publisher<?>> responseFunction, ReactiveAdapter returnTypeAdapter) implements ResponseFunction
    {
        @Override
        public Object execute(HttpRequestValues requestValues) {
            Publisher<?> responsePublisher = this.responseFunction.apply(requestValues);
            return this.returnTypeAdapter.fromPublisher(responsePublisher);
        }

        @Nullable
        public static ResponseFunction create(ReactorHttpExchangeAdapter client, Method method) {
            Function<HttpRequestValues, Publisher<?>> responseFunction;
            MethodParameter returnParam = new MethodParameter(method, -1);
            Class returnType = returnParam.getParameterType();
            ReactiveAdapter reactiveAdapter = client.getReactiveAdapterRegistry().getAdapter(returnType);
            if (reactiveAdapter == null) {
                return null;
            }
            MethodParameter actualParam = returnParam.nested();
            Class actualType = actualParam.getNestedParameterType();
            if (ClassUtils.isVoidType((Class)actualType)) {
                responseFunction = client::exchangeForMono;
            } else if (reactiveAdapter.isNoValue()) {
                responseFunction = client::exchangeForMono;
            } else if (actualType == HttpHeaders.class) {
                responseFunction = client::exchangeForHeadersMono;
            } else if (actualType == ResponseEntity.class) {
                MethodParameter bodyParam = actualParam.nested();
                Class bodyType = bodyParam.getNestedParameterType();
                if (bodyType.equals(Void.class)) {
                    responseFunction = client::exchangeForBodilessEntityMono;
                } else {
                    ReactiveAdapter bodyAdapter = client.getReactiveAdapterRegistry().getAdapter(bodyType);
                    responseFunction = ReactorExchangeResponseFunction.initResponseEntityFunction(client, bodyParam, bodyAdapter);
                }
            } else if (actualType == infra.web.client.reactive.ClientResponse.class) {
                responseFunction = client::exchangeMono;
            } else if (actualType == ClientResponse.class) {
                ReactiveAdapter futureAdapter = client.getReactiveAdapterRegistry().getAdapter(infra.util.concurrent.Future.class);
                Assert.state((futureAdapter != null ? 1 : 0) != 0, (String)"Future reactive adapter not found");
                responseFunction = request -> futureAdapter.toPublisher(client.exchangeAsync((HttpRequestValues)request));
            } else {
                responseFunction = ReactorExchangeResponseFunction.initBodyFunction(client, actualParam, reactiveAdapter);
            }
            return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter);
        }

        private static Function<HttpRequestValues, Publisher<?>> initResponseEntityFunction(ReactorHttpExchangeAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter) {
            if (reactiveAdapter == null) {
                return request -> client.exchangeForEntityMono((HttpRequestValues)request, ParameterizedTypeReference.forType((Type)methodParam.getNestedGenericParameterType()));
            }
            Assert.isTrue((boolean)reactiveAdapter.isMultiValue(), (String)"ResponseEntity body must be a concrete value or a multi-value Publisher");
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType((Type)methodParam.nested().getNestedGenericParameterType());
            if (reactiveAdapter.getReactiveType().equals(Flux.class)) {
                return request -> client.exchangeForEntityFlux((HttpRequestValues)request, bodyType);
            }
            return request -> client.exchangeForEntityFlux((HttpRequestValues)request, bodyType).map(entity -> {
                Object body = reactiveAdapter.fromPublisher((Publisher)entity.getBody());
                return new ResponseEntity<Object>(body, (MultiValueMap<String, String>)entity.getHeaders(), entity.getStatusCode());
            });
        }

        private static Function<HttpRequestValues, Publisher<?>> initBodyFunction(ReactorHttpExchangeAdapter client, MethodParameter methodParam, ReactiveAdapter reactiveAdapter) {
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType((Type)methodParam.getNestedGenericParameterType());
            return reactiveAdapter.isMultiValue() ? request -> client.exchangeForBodyFlux((HttpRequestValues)request, bodyType) : request -> client.exchangeForBodyMono((HttpRequestValues)request, bodyType);
        }
    }

    private static interface ResponseFunction {
        @Nullable
        public Object execute(HttpRequestValues var1);
    }
}

