/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.invoker;

import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.util.UriBuilderFactory;
import infra.web.util.UriComponentsBuilder;
import infra.web.util.UriUtils;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpRequestValues {
    private static final MultiValueMap<String, String> EMPTY_COOKIES_MAP = MultiValueMap.empty();
    @Nullable
    private final HttpMethod httpMethod;
    @Nullable
    private final URI uri;
    @Nullable
    private final UriBuilderFactory uriBuilderFactory;
    @Nullable
    private final String uriTemplate;
    private final Map<String, String> uriVariables;
    private final HttpHeaders headers;
    private final MultiValueMap<String, String> cookies;
    private final Map<String, Object> attributes;
    @Nullable
    private final Object bodyValue;

    protected HttpRequestValues(@Nullable HttpMethod httpMethod, @Nullable URI uri, @Nullable UriBuilderFactory uriBuilderFactory, @Nullable String uriTemplate, Map<String, String> uriVariables, HttpHeaders headers, MultiValueMap<String, String> cookies, Map<String, Object> attributes, @Nullable Object bodyValue) {
        Assert.isTrue((uri != null || uriTemplate != null ? 1 : 0) != 0, (String)"Neither URI nor URI template");
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.uriBuilderFactory = uriBuilderFactory;
        this.uriTemplate = uriTemplate;
        this.uriVariables = uriVariables;
        this.headers = headers;
        this.cookies = cookies;
        this.attributes = attributes;
        this.bodyValue = bodyValue;
    }

    @Nullable
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Nullable
    public URI getUri() {
        return this.uri;
    }

    @Nullable
    public UriBuilderFactory getUriBuilderFactory() {
        return this.uriBuilderFactory;
    }

    @Nullable
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public Map<String, String> getUriVariables() {
        return this.uriVariables;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, String> getCookies() {
        return this.cookies;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public Object getBodyValue() {
        return this.bodyValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Metadata {
        @Nullable
        private HttpMethod httpMethod;
        @Nullable
        private URI uri;
        @Nullable
        private UriBuilderFactory uriBuilderFactory;
        @Nullable
        private String uriTemplate;
        @Nullable
        private Map<String, String> uriVars;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private MultiValueMap<String, String> cookies;
        @Nullable
        private MultiValueMap<String, String> requestParams;
        @Nullable
        private MultiValueMap<String, Object> parts;
        @Nullable
        private Map<String, Object> attributes;
        @Nullable
        private Object bodyValue;

        public Builder setHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setUriBuilderFactory(@Nullable UriBuilderFactory uriBuilderFactory) {
            this.uriBuilderFactory = uriBuilderFactory;
            return this;
        }

        public Builder setUriTemplate(String uriTemplate) {
            this.uriTemplate = uriTemplate;
            return this;
        }

        public Builder setUriVariable(String name, String value) {
            this.uriVars = this.uriVars != null ? this.uriVars : new LinkedHashMap<String, String>();
            this.uriVars.put(name, value);
            return this;
        }

        public Builder setAccept(List<MediaType> acceptableMediaTypes) {
            this.initHeaders().setAccept(acceptableMediaTypes);
            return this;
        }

        public Builder setContentType(MediaType contentType) {
            this.initHeaders().setContentType(contentType);
            return this;
        }

        public Builder addHeader(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.initHeaders().add(headerName, headerValue);
            }
            return this;
        }

        private HttpHeaders initHeaders() {
            this.headers = this.headers != null ? this.headers : HttpHeaders.forWritable();
            return this.headers;
        }

        public Builder addCookie(String name, String ... values) {
            this.cookies = this.cookies != null ? this.cookies : new LinkedMultiValueMap();
            for (String value : values) {
                this.cookies.add((Object)name, (Object)value);
            }
            return this;
        }

        public Builder addRequestParameter(String name, String ... values) {
            this.requestParams = this.requestParams != null ? this.requestParams : new LinkedMultiValueMap();
            for (String value : values) {
                this.requestParams.add((Object)name, (Object)value);
            }
            return this;
        }

        public Builder addRequestPart(String name, Object part) {
            this.parts = this.parts != null ? this.parts : new LinkedMultiValueMap();
            this.parts.add((Object)name, part);
            return this;
        }

        public Builder addAttribute(String name, Object value) {
            this.attributes = this.attributes != null ? this.attributes : new HashMap<String, Object>();
            this.attributes.put(name, value);
            return this;
        }

        public void setBodyValue(Object bodyValue) {
            this.bodyValue = bodyValue;
        }

        @Override
        @Nullable
        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        @Nullable
        public String getUriTemplate() {
            return this.uriTemplate;
        }

        @Override
        @Nullable
        public MediaType getContentType() {
            return this.headers != null ? this.headers.getContentType() : null;
        }

        @Override
        @Nullable
        public List<MediaType> getAcceptMediaTypes() {
            return this.headers != null ? this.headers.getAccept() : null;
        }

        public HttpRequestValues build() {
            URI uri = this.uri;
            UriBuilderFactory uriBuilderFactory = this.uriBuilderFactory;
            String uriTemplate = this.uriTemplate;
            if (uriTemplate == null) {
                uriTemplate = "";
            }
            HashMap<String, String> uriVars = this.uriVars != null ? new HashMap<String, String>(this.uriVars) : Collections.emptyMap();
            Object bodyValue = this.bodyValue;
            if (this.hasParts()) {
                Assert.isTrue((!this.hasBody() ? 1 : 0) != 0, (String)"Expected body or request parts, not both");
                bodyValue = this.buildMultipartBody();
            }
            if (CollectionUtils.isNotEmpty(this.requestParams)) {
                if (this.hasFormDataContentType()) {
                    Assert.isTrue((!this.hasParts() ? 1 : 0) != 0, (String)"Request parts not expected for a form data request");
                    Assert.isTrue((!this.hasBody() ? 1 : 0) != 0, (String)"Body not expected for a form data request");
                    bodyValue = new LinkedMultiValueMap(this.requestParams);
                } else if (uri != null) {
                    uri = ((UriComponentsBuilder)UriComponentsBuilder.fromUri(uri).queryParams((MultiValueMap)UriUtils.encodeQueryParams(this.requestParams))).build(true).toUri();
                } else {
                    uriVars = uriVars.isEmpty() ? new HashMap<String, String>() : uriVars;
                    uriTemplate = this.appendQueryParams(uriTemplate, uriVars, this.requestParams);
                }
            }
            HttpHeaders headers = HttpHeaders.empty();
            if (this.headers != null) {
                headers = HttpHeaders.forWritable();
                headers.putAll((Map)((Object)this.headers));
            }
            LinkedMultiValueMap cookies = this.cookies != null ? MultiValueMap.copyOf(this.cookies) : EMPTY_COOKIES_MAP;
            HashMap<String, Object> attributes = this.attributes != null ? new HashMap<String, Object>(this.attributes) : Collections.emptyMap();
            return this.createRequestValues(this.httpMethod, uri, uriBuilderFactory, uriTemplate, uriVars, headers, (MultiValueMap<String, String>)cookies, attributes, bodyValue);
        }

        protected boolean hasParts() {
            return this.parts != null;
        }

        protected boolean hasBody() {
            return this.bodyValue != null;
        }

        protected Object buildMultipartBody() {
            Assert.notNull(this.parts, (String)"`parts` is null, was hasParts() not called?");
            return this.parts;
        }

        private boolean hasFormDataContentType() {
            return this.headers != null && MediaType.APPLICATION_FORM_URLENCODED.equals(this.headers.getContentType());
        }

        private String appendQueryParams(String uriTemplate, Map<String, String> uriVars, MultiValueMap<String, String> requestParams) {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString(uriTemplate);
            int i = 0;
            for (Map.Entry entry : requestParams.entrySet()) {
                String nameVar = "queryParam" + i;
                uriVars.put(nameVar, (String)entry.getKey());
                List value = (List)entry.getValue();
                for (int j = 0; j < value.size(); ++j) {
                    String valueVar = nameVar + "[" + j + "]";
                    uriVars.put(valueVar, (String)value.get(j));
                    uriComponentsBuilder.queryParam("{" + nameVar + "}", "{" + valueVar + "}");
                }
                ++i;
            }
            return uriComponentsBuilder.build().toUriString();
        }

        protected HttpRequestValues createRequestValues(@Nullable HttpMethod httpMethod, @Nullable URI uri, @Nullable UriBuilderFactory uriBuilderFactory, @Nullable String uriTemplate, Map<String, String> uriVars, HttpHeaders headers, MultiValueMap<String, String> cookies, Map<String, Object> attributes, @Nullable Object bodyValue) {
            return new HttpRequestValues(httpMethod, uri, uriBuilderFactory, uriTemplate, uriVars, headers, cookies, attributes, bodyValue);
        }
    }

    public static interface Metadata {
        @Nullable
        public HttpMethod getHttpMethod();

        @Nullable
        public String getUriTemplate();

        @Nullable
        public MediaType getContentType();

        @Nullable
        public List<MediaType> getAcceptMediaTypes();
    }
}

