/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.invoker;

import infra.core.MethodParameter;
import infra.http.HttpMethod;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.service.invoker.HttpRequestValues;
import infra.web.service.invoker.HttpServiceArgumentResolver;

public class HttpMethodArgumentResolver
implements HttpServiceArgumentResolver {
    private static final Logger logger = LoggerFactory.getLogger(HttpMethodArgumentResolver.class);

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        if (!parameter.getParameterType().equals(HttpMethod.class)) {
            return false;
        }
        Assert.notNull((Object)argument, (String)"HttpMethod is required");
        HttpMethod httpMethod = (HttpMethod)((Object)argument);
        requestValues.setHttpMethod(httpMethod);
        if (logger.isTraceEnabled()) {
            logger.trace("Resolved HTTP method to: {}", (Object)httpMethod.name());
        }
        return true;
    }
}

