/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.invoker;

import infra.core.ParameterizedTypeReference;
import infra.core.ReactiveAdapterRegistry;
import infra.http.ResponseEntity;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.concurrent.Future;
import infra.web.client.ClientResponse;
import infra.web.service.invoker.HttpRequestValues;
import infra.web.service.invoker.ReactorHttpExchangeAdapter;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import reactor.core.publisher.Mono;

public abstract class AbstractReactorHttpExchangeAdapter
implements ReactorHttpExchangeAdapter {
    private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
    @Nullable
    private Duration blockTimeout;

    protected AbstractReactorHttpExchangeAdapter() {
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    public void setBlockTimeout(@Nullable Duration blockTimeout) {
        this.blockTimeout = blockTimeout;
    }

    @Override
    @Nullable
    public Duration getBlockTimeout() {
        return this.blockTimeout;
    }

    @Override
    public abstract ClientResponse exchange(HttpRequestValues var1);

    @Override
    public abstract Future<ClientResponse> exchangeAsync(HttpRequestValues var1);

    @Override
    public <T> T exchangeForBody(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.blockingGet(this.exchangeForBodyMono(requestValues, bodyType));
    }

    @Override
    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues requestValues) {
        ResponseEntity<Void> entity = this.blockingGet(this.exchangeForBodilessEntityMono(requestValues));
        Assert.state((entity != null ? 1 : 0) != 0, (String)"Expected ResponseEntity");
        return entity;
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        ResponseEntity<T> entity = this.blockingGet(this.exchangeForEntityMono(requestValues, bodyType));
        Assert.state((entity != null ? 1 : 0) != 0, (String)"Expected ResponseEntity");
        return entity;
    }

    @Override
    public <T> Future<ResponseEntity<T>> exchangeForEntityAsync(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return Future.forAdaption((CompletionStage)this.exchangeForEntityMono(requestValues, bodyType).toFuture());
    }

    @Override
    public Future<ResponseEntity<Void>> exchangeForBodilessEntityAsync(HttpRequestValues requestValues) {
        return Future.forAdaption((CompletionStage)this.exchangeForBodilessEntityMono(requestValues).toFuture());
    }

    @Nullable
    protected final <T> T blockingGet(Mono<T> mono) {
        if (this.blockTimeout != null) {
            return (T)mono.block(this.blockTimeout);
        }
        return (T)mono.block();
    }
}

