/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.annotation;

import infra.aot.hint.BindingReflectionHintsRegistrar;
import infra.aot.hint.ExecutableMode;
import infra.aot.hint.ReflectionHints;
import infra.aot.hint.annotation.ReflectiveProcessor;
import infra.core.MethodParameter;
import infra.web.annotation.RequestBody;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;

class HttpExchangeReflectiveProcessor
implements ReflectiveProcessor {
    private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

    HttpExchangeReflectiveProcessor() {
    }

    public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        if (element instanceof Method) {
            Method method = (Method)element;
            this.registerMethodHints(hints, method);
        }
    }

    protected void registerMethodHints(ReflectionHints hints, Method method) {
        hints.registerMethod(method, ExecutableMode.INVOKE);
        for (Parameter parameter : method.getParameters()) {
            this.registerParameterTypeHints(hints, MethodParameter.forParameter((Parameter)parameter));
        }
        this.registerReturnTypeHints(hints, MethodParameter.forExecutable((Executable)method, (int)-1));
    }

    protected void registerParameterTypeHints(ReflectionHints hints, MethodParameter methodParameter) {
        if (methodParameter.hasParameterAnnotation(RequestBody.class)) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{methodParameter.getGenericParameterType()});
        }
    }

    protected void registerReturnTypeHints(ReflectionHints hints, MethodParameter returnTypeParameter) {
        if (!Void.TYPE.equals(returnTypeParameter.getParameterType())) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{returnTypeParameter.getGenericParameterType()});
        }
    }
}

