/*
 * Decompiled with CFR 0.152.
 */
package infra.web.service.annotation;

import infra.aop.framework.AopProxyUtils;
import infra.aot.generate.GenerationContext;
import infra.aot.hint.ProxyHints;
import infra.beans.factory.aot.BeanRegistrationAotContribution;
import infra.beans.factory.aot.BeanRegistrationAotProcessor;
import infra.beans.factory.aot.BeanRegistrationCode;
import infra.beans.factory.support.RegisteredBean;
import infra.core.annotation.MergedAnnotations;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.ReflectionUtils;
import infra.web.service.annotation.HttpExchange;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;

class HttpExchangeBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    HttpExchangeBeanRegistrationAotProcessor() {
    }

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        ArrayList exchangeInterfaces = new ArrayList();
        MergedAnnotations.Search search = MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        for (Class interfaceClass : ClassUtils.getAllInterfacesForClass((Class)beanClass)) {
            ReflectionUtils.doWithMethods((Class)interfaceClass, method -> {
                if (!exchangeInterfaces.contains(interfaceClass) && search.from((AnnotatedElement)method).isPresent(HttpExchange.class)) {
                    exchangeInterfaces.add(interfaceClass);
                }
            });
        }
        if (!exchangeInterfaces.isEmpty()) {
            return new AotContribution(exchangeInterfaces);
        }
        return null;
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final List<Class<?>> httpExchangeInterfaces;

        public AotContribution(List<Class<?>> httpExchangeInterfaces) {
            this.httpExchangeInterfaces = httpExchangeInterfaces;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ProxyHints proxyHints = generationContext.getRuntimeHints().proxies();
            for (Class<?> httpExchangeInterface : this.httpExchangeInterfaces) {
                proxyHints.registerJdkProxy(AopProxyUtils.completeJdkProxyInterfaces((Class[])new Class[]{httpExchangeInterface}));
            }
        }
    }
}

