/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.core.ssl.SslBundle;
import infra.core.ssl.SslOptions;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.ExceptionUtils;
import infra.util.ObjectUtils;
import infra.web.server.Ssl;
import infra.web.server.support.ChannelConfigurer;
import infra.web.server.support.NettyChannelInitializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;

final class SSLNettyChannelInitializer
extends NettyChannelInitializer {
    private static final Logger logger = LoggerFactory.getLogger(SSLNettyChannelInitializer.class);
    @Nullable
    private final HashMap<String, SslContext> serverNameSslContexts;
    private final long handshakeTimeout;
    private final ClientAuth clientAuth;
    private final boolean http2Enabled;
    private volatile SslContext sslContext;

    public SSLNettyChannelInitializer(ChannelHandler channelHandler, @Nullable ChannelConfigurer channelConfigurer, boolean http2Enabled, Ssl ssl, SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
        super(channelHandler, channelConfigurer);
        this.http2Enabled = http2Enabled;
        this.handshakeTimeout = ssl.handshakeTimeout.toMillis();
        this.clientAuth = Ssl.ClientAuth.map(ssl.clientAuth, ClientAuth.NONE, ClientAuth.OPTIONAL, ClientAuth.REQUIRE);
        this.sslContext = this.createSslContext(sslBundle);
        this.serverNameSslContexts = this.createServerNameSSLContexts(serverNameSslBundles);
    }

    @Override
    protected void preInitChannel(@Nullable ChannelConfigurer configurer, Channel ch) {
        if (configurer != null) {
            configurer.initChannel(ch);
        }
        if (this.serverNameSslContexts != null) {
            SniHandler sniHandler = new SniHandler((hostname, promise) -> promise.setSuccess((Object)this.serverNameSslContexts.getOrDefault(hostname, this.sslContext)), this.handshakeTimeout);
            ch.pipeline().addLast("SNI-handler", (ChannelHandler)sniHandler);
        } else {
            SslHandler sslHandler = this.createSslHandler(ch);
            sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeout);
            ch.pipeline().addLast("SSL-handler", (ChannelHandler)sslHandler);
        }
    }

    public void updateSSLBundle(@Nullable String serverName, SslBundle sslBundle) {
        logger.debug("SSL Bundle has been updated, reloading SSL configuration");
        if (serverName == null) {
            this.sslContext = this.createSslContext(sslBundle);
        } else if (this.serverNameSslContexts != null) {
            this.serverNameSslContexts.put(serverName, this.createSslContext(sslBundle));
        }
    }

    private SslHandler createSslHandler(Channel ch) {
        SocketAddress socketAddress = ch.remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress sniInfo = (InetSocketAddress)socketAddress;
            return this.sslContext.newHandler(ch.alloc(), sniInfo.getHostString(), sniInfo.getPort());
        }
        return this.sslContext.newHandler(ch.alloc());
    }

    @Nullable
    private HashMap<String, SslContext> createServerNameSSLContexts(Map<String, SslBundle> serverNameSslBundles) {
        if (serverNameSslBundles.isEmpty()) {
            return null;
        }
        HashMap<String, SslContext> serverNameSslProviders = new HashMap<String, SslContext>(serverNameSslBundles.size());
        for (Map.Entry<String, SslBundle> entry : serverNameSslBundles.entrySet()) {
            serverNameSslProviders.put(entry.getKey(), this.createSslContext(entry.getValue()));
        }
        return serverNameSslProviders;
    }

    private SslContext createSslContext(SslBundle ssl) {
        SslOptions options = ssl.getOptions();
        try {
            return SslContextBuilder.forServer((KeyManagerFactory)ssl.getManagers().getKeyManagerFactory()).protocols(options.getEnabledProtocols()).sslProvider(this.getSslProvider()).ciphers(this.getCiphers(options), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).clientAuth(this.clientAuth).applicationProtocolConfig(this.http2Enabled ? new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}) : null).build();
        }
        catch (IOException e) {
            throw ExceptionUtils.sneakyThrow((Throwable)e);
        }
    }

    @Nullable
    private List<String> getCiphers(SslOptions options) {
        if (ObjectUtils.isNotEmpty((Object[])options.getCiphers())) {
            return Arrays.asList(options.getCiphers());
        }
        if (this.http2Enabled) {
            return Http2SecurityUtil.CIPHERS;
        }
        return null;
    }

    private SslProvider getSslProvider() {
        return this.http2Enabled ? (SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK) : (OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK);
    }
}

