/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.web.server.AbstractConfigurableWebServerFactory;
import infra.web.server.ChannelWebServerFactory;
import infra.web.server.ServerProperties;
import infra.web.server.Ssl;
import infra.web.server.WebServer;
import infra.web.server.support.ChannelConfigurer;
import infra.web.server.support.NettyChannelInitializer;
import infra.web.server.support.NettyWebServer;
import infra.web.server.support.SSLNettyChannelInitializer;
import infra.web.server.support.ServerBootstrapCustomizer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public class NettyWebServerFactory
extends AbstractConfigurableWebServerFactory
implements ChannelWebServerFactory {
    private int workerThreadCount = 4;
    private int acceptorThreadCount = 2;
    private int maxConnection = NetUtil.SOMAXCONN;
    @Nullable
    private EventLoopGroup workerGroup;
    @Nullable
    private EventLoopGroup acceptorGroup;
    @Nullable
    private Class<? extends ServerSocketChannel> socketChannel;
    @Nullable
    private LogLevel loggingLevel;
    @Nullable
    private List<ServerBootstrapCustomizer> bootstrapCustomizers;
    private ServerProperties.Netty nettyConfig = new ServerProperties.Netty();
    @Nullable
    private ChannelConfigurer channelConfigurer;
    @Nullable
    private String workerPoolName;
    @Nullable
    private String acceptorPoolName;

    public void setAcceptorGroup(@Nullable EventLoopGroup acceptorGroup) {
        this.acceptorGroup = acceptorGroup;
    }

    public void setWorkerGroup(@Nullable EventLoopGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public void setSocketChannel(@Nullable Class<? extends ServerSocketChannel> socketChannel) {
        this.socketChannel = socketChannel;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setWorkerThreadCount(int workThreadCount) {
        this.workerThreadCount = workThreadCount;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public int getWorkThreadCount() {
        return this.workerThreadCount;
    }

    public void setLoggingLevel(LogLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setChannelConfigurer(@Nullable ChannelConfigurer channelConfigurer) {
        this.channelConfigurer = channelConfigurer;
    }

    public void setBootstrapCustomizers(@Nullable List<ServerBootstrapCustomizer> bootstrapCustomizers) {
        this.bootstrapCustomizers = bootstrapCustomizers;
    }

    public void setWorkerPoolName(@Nullable String workerPoolName) {
        this.workerPoolName = workerPoolName;
    }

    public void setAcceptorPoolName(@Nullable String acceptorPoolName) {
        this.acceptorPoolName = acceptorPoolName;
    }

    @Nullable
    public LogLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    @Nullable
    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @Nullable
    public EventLoopGroup getAcceptorGroup() {
        return this.acceptorGroup;
    }

    @Nullable
    public Class<? extends ServerSocketChannel> getSocketChannel() {
        return this.socketChannel;
    }

    protected boolean epollIsAvailable() {
        return ClassUtils.isPresent((String)"io.netty.channel.epoll.EpollServerSocketChannel", this.getClass()) && Epoll.isAvailable();
    }

    protected boolean kQueueIsAvailable() {
        return ClassUtils.isPresent((String)"io.netty.channel.kqueue.KQueueServerSocketChannel", this.getClass()) && KQueue.isAvailable();
    }

    @Override
    public WebServer getWebServer(ChannelHandler channelHandler) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        this.preBootstrap(bootstrap);
        if (this.epollIsAvailable()) {
            EpollDelegate.init(bootstrap, this);
        } else if (this.kQueueIsAvailable()) {
            KQueueDelegate.init(this);
        } else {
            if (this.acceptorGroup == null) {
                this.acceptorGroup = new NioEventLoopGroup(this.acceptorThreadCount, (ThreadFactory)new DefaultThreadFactory(this.acceptorPoolName == null ? "acceptor" : this.acceptorPoolName));
            }
            if (this.workerGroup == null) {
                this.workerGroup = new NioEventLoopGroup(this.workerThreadCount, (ThreadFactory)new DefaultThreadFactory(this.workerPoolName == null ? "workers" : this.workerPoolName));
            }
            if (this.socketChannel == null) {
                this.socketChannel = NioServerSocketChannel.class;
            }
        }
        Assert.state((this.workerGroup != null ? 1 : 0) != 0, (String)"No 'workerGroup'");
        Assert.state((this.acceptorGroup != null ? 1 : 0) != 0, (String)"No 'acceptorGroup'");
        bootstrap.group(this.acceptorGroup, this.workerGroup);
        bootstrap.channel(this.socketChannel);
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.maxConnection);
        if (this.loggingLevel != null) {
            bootstrap.handler((ChannelHandler)new LoggingHandler(this.loggingLevel));
        }
        bootstrap.childHandler(this.createChannelInitializer(this.nettyConfig, channelHandler));
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        if (this.bootstrapCustomizers != null) {
            for (ServerBootstrapCustomizer customizer : this.bootstrapCustomizers) {
                customizer.customize(bootstrap);
            }
        }
        this.postBootstrap(bootstrap);
        InetSocketAddress listenAddress = this.getListenAddress();
        return new NettyWebServer(this.acceptorGroup, this.workerGroup, bootstrap, listenAddress, this.nettyConfig.shutdown, Ssl.isEnabled(this.getSsl()));
    }

    protected ChannelInitializer<Channel> createChannelInitializer(ServerProperties.Netty netty, ChannelHandler channelHandler) {
        NettyChannelInitializer initializer = this.createInitializer(channelHandler);
        initializer.setHttpDecoderConfig(this.createHttpDecoderConfig(netty));
        initializer.setMaxContentLength(netty.maxContentLength.toBytesInt());
        initializer.setCloseOnExpectationFailed(netty.closeOnExpectationFailed);
        return initializer;
    }

    protected final HttpDecoderConfig createHttpDecoderConfig(ServerProperties.Netty netty) {
        return new HttpDecoderConfig().setInitialBufferSize(netty.initialBufferSize.toBytesInt()).setMaxChunkSize(netty.maxChunkSize.toBytesInt()).setMaxHeaderSize(netty.maxHeaderSize.toBytesInt()).setValidateHeaders(netty.validateHeaders).setChunkedSupported(netty.chunkedSupported).setAllowPartialChunks(netty.allowPartialChunks).setMaxInitialLineLength(netty.maxInitialLineLength).setAllowDuplicateContentLengths(netty.allowDuplicateContentLengths);
    }

    protected void preBootstrap(ServerBootstrap bootstrap) {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
    }

    protected void postBootstrap(ServerBootstrap bootstrap) {
    }

    public void applyFrom(ServerProperties.Netty netty) {
        if (netty.loggingLevel != null) {
            this.setLoggingLevel(netty.loggingLevel);
        }
        if (netty.socketChannel != null) {
            this.setSocketChannel(netty.socketChannel);
        }
        if (netty.acceptorThreads != null) {
            this.setAcceptorThreadCount(netty.acceptorThreads);
        }
        if (netty.workerThreads != null) {
            this.setWorkerThreadCount(netty.workerThreads);
        }
        if (netty.maxConnection != null) {
            this.setMaxConnection(netty.maxConnection);
        }
        this.setWorkerPoolName(netty.workerPoolName);
        this.setAcceptorPoolName(netty.acceptorPoolName);
        this.nettyConfig = netty;
    }

    private NettyChannelInitializer createInitializer(ChannelHandler channelHandler) {
        Ssl ssl = this.getSsl();
        if (Ssl.isEnabled(ssl)) {
            SSLNettyChannelInitializer initializer = new SSLNettyChannelInitializer(channelHandler, this.channelConfigurer, this.isHttp2Enabled(), ssl, this.getSslBundle(), this.getServerNameSslBundles());
            this.addBundleUpdateHandler(ssl, initializer::updateSSLBundle);
            return initializer;
        }
        return new NettyChannelInitializer(channelHandler, this.channelConfigurer);
    }

    private InetSocketAddress getListenAddress() {
        if (this.getAddress() != null) {
            return new InetSocketAddress(this.getAddress().getHostAddress(), this.getPort());
        }
        return new InetSocketAddress(this.getPort());
    }

    static class EpollDelegate {
        EpollDelegate() {
        }

        static void init(ServerBootstrap bootstrap, NettyWebServerFactory factory) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            if (factory.getSocketChannel() == null) {
                factory.setSocketChannel(EpollServerSocketChannel.class);
            }
            if (factory.getAcceptorGroup() == null) {
                factory.setAcceptorGroup((EventLoopGroup)new EpollEventLoopGroup(factory.acceptorThreadCount, (ThreadFactory)new DefaultThreadFactory(factory.acceptorPoolName == null ? "epoll-acceptor" : factory.acceptorPoolName)));
            }
            if (factory.getWorkerGroup() == null) {
                factory.setWorkerGroup((EventLoopGroup)new EpollEventLoopGroup(factory.workerThreadCount, (ThreadFactory)new DefaultThreadFactory(factory.workerPoolName == null ? "epoll-workers" : factory.workerPoolName)));
            }
        }
    }

    static class KQueueDelegate {
        KQueueDelegate() {
        }

        static void init(NettyWebServerFactory factory) {
            if (factory.getSocketChannel() == null) {
                factory.setSocketChannel(KQueueServerSocketChannel.class);
            }
            if (factory.getAcceptorGroup() == null) {
                factory.setAcceptorGroup((EventLoopGroup)new KQueueEventLoopGroup(factory.workerThreadCount, (ThreadFactory)new DefaultThreadFactory(factory.acceptorPoolName == null ? "kQueue-acceptor" : factory.acceptorPoolName)));
            }
            if (factory.getWorkerGroup() == null) {
                factory.setWorkerGroup((EventLoopGroup)new KQueueEventLoopGroup(factory.workerThreadCount, (ThreadFactory)new DefaultThreadFactory(factory.workerPoolName == null ? "kQueue-workers" : factory.workerPoolName)));
            }
        }
    }
}

