/*
 * Decompiled with CFR 0.152.
 */
package infra.web.server.support;

import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.server.GracefulShutdownCallback;
import infra.web.server.GracefulShutdownResult;
import infra.web.server.PortInUseException;
import infra.web.server.ServerProperties;
import infra.web.server.WebServer;
import infra.web.server.WebServerException;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.IntSupplier;

final class NettyWebServer
implements WebServer,
IntSupplier {
    private static final Logger log = LoggerFactory.getLogger(NettyWebServer.class);
    private final EventLoopGroup childGroup;
    private final boolean sslEnabled;
    private final EventLoopGroup parentGroup;
    private final ServerProperties.Netty.Shutdown shutdownConfig;
    private final ServerBootstrap serverBootstrap;
    private volatile boolean shutdownComplete = false;
    private InetSocketAddress listenAddress;

    NettyWebServer(EventLoopGroup parentGroup, EventLoopGroup childGroup, ServerBootstrap serverBootstrap, InetSocketAddress listenAddress, ServerProperties.Netty.Shutdown shutdownConfig, boolean sslEnabled) {
        this.serverBootstrap = serverBootstrap;
        this.shutdownConfig = shutdownConfig;
        this.listenAddress = listenAddress;
        this.parentGroup = parentGroup;
        this.childGroup = childGroup;
        this.sslEnabled = sslEnabled;
    }

    @Override
    public void start() throws WebServerException {
        try {
            SocketAddress socketAddress = this.serverBootstrap.bind((SocketAddress)this.listenAddress).syncUninterruptibly().channel().localAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress localAddress;
                this.listenAddress = localAddress = (InetSocketAddress)socketAddress;
            }
            log.info("Netty started on port: {} {}", (Object)this.getPort(), (Object)(this.sslEnabled ? "(https)" : "(http)"));
        }
        catch (Exception ex) {
            PortInUseException.throwIfPortBindingException(ex, this);
            throw new WebServerException("Unable to start Netty", ex);
        }
    }

    @Override
    public int getAsInt() {
        return this.getPort();
    }

    @Override
    public void stop() {
        log.info("Shutdown netty web server: [{}] on port: '{}'", (Object)this, (Object)this.getPort());
        if (!this.shutdownComplete) {
            this.shutdown();
        }
    }

    private void shutdown() {
        this.parentGroup.shutdownGracefully(this.shutdownConfig.quietPeriod, this.shutdownConfig.timeout, this.shutdownConfig.unit);
        this.childGroup.shutdownGracefully(this.shutdownConfig.quietPeriod, this.shutdownConfig.timeout, this.shutdownConfig.unit);
    }

    @Override
    public void shutDownGracefully(GracefulShutdownCallback callback) {
        log.info("Commencing graceful shutdown. Waiting for active requests to complete");
        try {
            this.shutdown();
            this.childGroup.terminationFuture().sync();
            this.parentGroup.terminationFuture().sync();
            this.shutdownComplete = true;
            callback.shutdownComplete(GracefulShutdownResult.IDLE);
            log.info("Graceful shutdown complete");
        }
        catch (Exception ex) {
            log.info("Graceful shutdown aborted with one or more requests still active");
            callback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
        }
    }

    @Override
    public int getPort() {
        return this.listenAddress.getPort();
    }
}

